/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.authentication.jwt;

import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.source.ImmutableJWKSet;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.jwk.source.RemoteJWKSet;
import com.nimbusds.jose.proc.SecurityContext;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.authentication.AuthenticationException;
import org.mockserver.authentication.AuthenticationHandler;
import org.mockserver.authentication.jwt.JWTValidator;
import org.mockserver.file.FilePath;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.HttpRequest;
import org.mockserver.url.URLParser;
import org.slf4j.event.Level;

public class JWTAuthenticationHandler
implements AuthenticationHandler {
    private final MockServerLogger mockServerLogger;
    private Throwable jwtValidatorInitialisationException;
    private JWTValidator jwtValidator;

    public JWTAuthenticationHandler(MockServerLogger mockServerLogger, String jwkSource) {
        this.mockServerLogger = mockServerLogger;
        try {
            this.jwtValidator = URLParser.isFullUrl(jwkSource) ? new JWTValidator((JWKSource<SecurityContext>)new RemoteJWKSet(new URL(jwkSource))) : new JWTValidator((JWKSource<SecurityContext>)new ImmutableJWKSet(JWKSet.load((File)new File(FilePath.absolutePathFromClassPathOrPath(jwkSource)))));
        }
        catch (Throwable throwable) {
            mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception building JWT validator for:{}").setArguments(jwkSource).setThrowable(throwable));
            this.jwtValidatorInitialisationException = throwable;
        }
    }

    public JWTAuthenticationHandler withExpectedAudience(String expectedAudience) {
        this.jwtValidator.withExpectedAudience(expectedAudience);
        return this;
    }

    public JWTAuthenticationHandler withMatchingClaims(Map<String, String> matchingClaims) {
        this.jwtValidator.withMatchingClaims(matchingClaims);
        return this;
    }

    public JWTAuthenticationHandler withRequiredClaims(Set<String> requiredClaims) {
        this.jwtValidator.withRequiredClaims(requiredClaims);
        return this;
    }

    @Override
    public boolean controlPlaneRequestAuthenticated(HttpRequest request) {
        if (this.jwtValidator == null) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setHttpRequest(request).setMessageFormat("JWT control plane request failed authentication because JWT validator is not initialised:{}").setArguments(request).setThrowable(this.jwtValidatorInitialisationException));
        } else {
            List<String> authorizationHeaders = request.getHeader(HttpHeaderNames.AUTHORIZATION.toString());
            if (authorizationHeaders.isEmpty()) {
                this.logAuthorisationFailure(request, "no authorization header found");
            }
            for (String authorizationHeader : authorizationHeaders) {
                int idx = authorizationHeader.indexOf(32);
                if (idx <= 0) {
                    this.logAuthorisationFailure(request, "authorization header is invalid format");
                    continue;
                }
                String headerPrefix = authorizationHeader.substring(0, idx);
                if (StringUtils.isBlank((CharSequence)headerPrefix)) {
                    this.logAuthorisationFailure(request, "authorization type must be specified for authorization header");
                    continue;
                }
                if ("Bearer".equalsIgnoreCase(headerPrefix)) {
                    this.jwtValidator.validate(authorizationHeader.substring(idx + 1));
                    return true;
                }
                this.logAuthorisationFailure(request, "only \"Bearer\" supported for authorization header");
            }
        }
        return false;
    }

    private void logAuthorisationFailure(HttpRequest request, String failureReason) {
        this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setHttpRequest(request).setMessageFormat("JWT control plane request failed:{}for request:{}").setArguments(failureReason, request));
        throw new AuthenticationException(failureReason);
    }
}

