/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.openapi.examples.models;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import org.mockserver.openapi.examples.JsonExampleDeserializer;
import org.mockserver.openapi.examples.models.AbstractExample;
import org.mockserver.openapi.examples.models.Example;

@JsonDeserialize(using=JsonExampleDeserializer.class)
public class ArrayExample
extends AbstractExample {
    List<Example> values = null;

    public ArrayExample() {
        super.setTypeName("array");
    }

    public void add(Example value) {
        if (this.values == null) {
            this.values = new ArrayList<Example>();
        }
        this.values.add(value);
    }

    @Override
    public String asString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        if (this.values != null) {
            for (int i = 0; i < this.values.size(); ++i) {
                Example example = this.values.get(i);
                builder.append(example.asString());
                if (i <= 0) continue;
                builder.append(",");
            }
        }
        builder.append("]");
        return builder.toString();
    }

    public List<Example> getItems() {
        if (this.values == null) {
            return new ArrayList<Example>();
        }
        return this.values;
    }
}

