/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.deserializers.request;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.model.Cookies;
import org.mockserver.model.Headers;
import org.mockserver.model.NottableString;
import org.mockserver.model.Parameters;
import org.mockserver.model.SocketAddress;
import org.mockserver.serialization.model.BodyDTO;
import org.mockserver.serialization.model.HttpRequestDTO;
import org.mockserver.serialization.model.OpenAPIDefinitionDTO;
import org.mockserver.serialization.model.RequestDefinitionDTO;

public class RequestDefinitionDTODeserializer
extends StdDeserializer<RequestDefinitionDTO> {
    public RequestDefinitionDTODeserializer() {
        super(RequestDefinitionDTO.class);
    }

    public RequestDefinitionDTO deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        if (jsonParser.getCurrentToken() == JsonToken.START_OBJECT) {
            Boolean not = null;
            NottableString method = NottableString.string("");
            NottableString path = NottableString.string("");
            Parameters pathParameters = null;
            Parameters queryStringParameters = null;
            BodyDTO body = null;
            Cookies cookies = null;
            Headers headers = null;
            Boolean keepAlive = null;
            Boolean secure = null;
            SocketAddress socketAddress = null;
            String specUrlOrPayload = null;
            String operationId = null;
            while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = jsonParser.getCurrentName();
                if (fieldName == null) continue;
                switch (fieldName) {
                    case "not": {
                        jsonParser.nextToken();
                        not = jsonParser.getBooleanValue();
                        break;
                    }
                    case "method": {
                        jsonParser.nextToken();
                        method = (NottableString)ctxt.readValue(jsonParser, NottableString.class);
                        break;
                    }
                    case "path": {
                        jsonParser.nextToken();
                        path = (NottableString)ctxt.readValue(jsonParser, NottableString.class);
                        break;
                    }
                    case "pathParameters": {
                        jsonParser.nextToken();
                        pathParameters = (Parameters)ctxt.readValue(jsonParser, Parameters.class);
                        break;
                    }
                    case "queryStringParameters": {
                        jsonParser.nextToken();
                        queryStringParameters = (Parameters)ctxt.readValue(jsonParser, Parameters.class);
                        break;
                    }
                    case "body": {
                        jsonParser.nextToken();
                        body = (BodyDTO)ctxt.readValue(jsonParser, BodyDTO.class);
                        break;
                    }
                    case "cookies": {
                        jsonParser.nextToken();
                        cookies = (Cookies)ctxt.readValue(jsonParser, Cookies.class);
                        break;
                    }
                    case "headers": {
                        jsonParser.nextToken();
                        headers = (Headers)ctxt.readValue(jsonParser, Headers.class);
                        break;
                    }
                    case "keepAlive": {
                        jsonParser.nextToken();
                        keepAlive = (Boolean)ctxt.readValue(jsonParser, Boolean.class);
                        break;
                    }
                    case "secure": {
                        jsonParser.nextToken();
                        secure = (Boolean)ctxt.readValue(jsonParser, Boolean.class);
                        break;
                    }
                    case "socketAddress": {
                        jsonParser.nextToken();
                        socketAddress = (SocketAddress)ctxt.readValue(jsonParser, SocketAddress.class);
                        break;
                    }
                    case "specUrlOrPayload": {
                        jsonParser.nextToken();
                        JsonNode potentiallyJsonField = (JsonNode)ctxt.readValue(jsonParser, JsonNode.class);
                        if (potentiallyJsonField.isTextual()) {
                            specUrlOrPayload = potentiallyJsonField.asText();
                            break;
                        }
                        specUrlOrPayload = potentiallyJsonField.toPrettyString();
                        break;
                    }
                    case "operationId": {
                        jsonParser.nextToken();
                        operationId = (String)ctxt.readValue(jsonParser, String.class);
                    }
                }
            }
            if (StringUtils.isNotBlank(specUrlOrPayload)) {
                return (RequestDefinitionDTO)new OpenAPIDefinitionDTO().setSpecUrlOrPayload(specUrlOrPayload).setOperationId(operationId).setNot(not);
            }
            return (RequestDefinitionDTO)new HttpRequestDTO().setMethod(method).setPath(path).setPathParameters(pathParameters).setQueryStringParameters(queryStringParameters).setBody(body).setCookies(cookies).setHeaders(headers).setKeepAlive(keepAlive).setSecure(secure).setSocketAddress(socketAddress).setNot(not);
        }
        return null;
    }
}

