/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.templates.engine.javascript.bindings;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.script.Bindings;
import org.apache.commons.lang3.NotImplementedException;

public class ScriptBindings
implements Bindings {
    private final Map<String, Supplier<Object>> suppliers;
    private final Map<String, Object> otherState;

    public ScriptBindings(Map<String, Supplier<Object>> suppliers) {
        this.suppliers = suppliers;
        this.otherState = new ConcurrentHashMap<String, Object>();
    }

    @Override
    public Object put(String name, Object value) {
        return this.otherState.put(name, value);
    }

    @Override
    public void putAll(Map<? extends String, ?> toMerge) {
        this.otherState.putAll(toMerge);
    }

    @Override
    public void clear() {
        this.otherState.clear();
        this.suppliers.clear();
    }

    @Override
    public Set<String> keySet() {
        throw new NotImplementedException("keySet not implemented by " + this.getClass().getSimpleName());
    }

    @Override
    public Collection<Object> values() {
        throw new NotImplementedException("values not implemented by " + this.getClass().getSimpleName());
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        throw new NotImplementedException("entrySet not implemented by " + this.getClass().getSimpleName());
    }

    @Override
    public int size() {
        return this.suppliers.size() + this.otherState.size();
    }

    @Override
    public boolean isEmpty() {
        return this.suppliers.isEmpty() && this.otherState.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.suppliers.containsKey(key) || this.otherState.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        throw new NotImplementedException("containsValue not implemented by " + this.getClass().getSimpleName());
    }

    @Override
    public Object get(Object key) {
        Supplier<Object> objectSupplier = this.suppliers.get(key);
        if (objectSupplier != null) {
            return objectSupplier.get();
        }
        return this.otherState.get(key);
    }

    @Override
    public Object remove(Object key) {
        this.otherState.remove(key);
        return this.suppliers.remove(key);
    }
}

