/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.pathmap;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.jetty.http.pathmap.MappedResource;
import org.eclipse.jetty.http.pathmap.PathMappings;
import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.http.pathmap.ServletPathSpec;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class ServletPathSpecMatchListTest {
    private static PathMappings<String> mappings = new PathMappings();

    public static Stream<Arguments> data() {
        ArrayList<Arguments> data = new ArrayList<Arguments>();
        data.add(Arguments.of((Object[])new Object[]{"All matches", "/animal/bird/path.tar.gz", "[/animal/bird/*=birds, /animal/*=animals, *.tar.gz=tarball, *.gz=gzipped, /=default]"}));
        data.add(Arguments.of((Object[])new Object[]{"Dir matches", "/animal/fish/", "[/animal/fish/*=fishes, /animal/*=animals, /=default]"}));
        data.add(Arguments.of((Object[])new Object[]{"Dir matches", "/animal/fish", "[/animal/fish/*=fishes, /animal/*=animals, /=default]"}));
        data.add(Arguments.of((Object[])new Object[]{"Root matches", "/", "[=root, /=default]"}));
        data.add(Arguments.of((Object[])new Object[]{"Dir matches", "", "[/=default]"}));
        return data.stream();
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testGetMatches(String message, String inputPath, String expectedListing) {
        List matches = mappings.getMatches(inputPath);
        StringBuilder actual = new StringBuilder();
        actual.append('[');
        boolean delim = false;
        for (MappedResource res : matches) {
            if (delim) {
                actual.append(", ");
            }
            actual.append(res.getPathSpec().getDeclaration()).append('=').append((String)res.getResource());
            delim = true;
        }
        actual.append(']');
        MatcherAssert.assertThat((String)(message + " on [" + inputPath + "]"), (Object)actual.toString(), (Matcher)Matchers.is((Object)expectedListing));
    }

    static {
        mappings.put((PathSpec)new ServletPathSpec("/abs/path"), (Object)"abspath");
        mappings.put((PathSpec)new ServletPathSpec("/abs/path/longer"), (Object)"longpath");
        mappings.put((PathSpec)new ServletPathSpec("/animal/bird/*"), (Object)"birds");
        mappings.put((PathSpec)new ServletPathSpec("/animal/fish/*"), (Object)"fishes");
        mappings.put((PathSpec)new ServletPathSpec("/animal/*"), (Object)"animals");
        mappings.put((PathSpec)new ServletPathSpec("*.tar.gz"), (Object)"tarball");
        mappings.put((PathSpec)new ServletPathSpec("*.gz"), (Object)"gzipped");
        mappings.put((PathSpec)new ServletPathSpec("/"), (Object)"default");
        mappings.put((PathSpec)new ServletPathSpec(""), (Object)"root");
        mappings.put((PathSpec)new ServletPathSpec("/\u20acuro/*"), (Object)"money");
    }
}

