/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.pathmap;

import org.eclipse.jetty.http.pathmap.MatchedPath;
import org.eclipse.jetty.http.pathmap.RegexPathSpec;
import org.eclipse.jetty.http.pathmap.ServletPathSpec;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class ServletPathSpecTest {
    private void assertMatches(ServletPathSpec spec, String path) {
        String msg = String.format("Spec(\"%s\").matches(\"%s\")", spec.getDeclaration(), path);
        MatcherAssert.assertThat((String)msg, (Object)spec.matched(path), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
    }

    private void assertNotMatches(ServletPathSpec spec, String path) {
        String msg = String.format("!Spec(\"%s\").matches(\"%s\")", spec.getDeclaration(), path);
        MatcherAssert.assertThat((String)msg, (Object)spec.matched(path), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @ParameterizedTest
    @ValueSource(strings={"foo", "/foo/*.do", "foo/*.do", "foo/*.*do", "*", "*do", "/foo/*/bar", "*/foo", "*.foo/*"})
    public void testBadPathSpecs(String str) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ServletPathSpec(str));
    }

    @Test
    public void testDefaultPathSpec() {
        ServletPathSpec spec = new ServletPathSpec("/");
        Assertions.assertEquals((Object)"/", (Object)spec.getDeclaration(), (String)"Spec.pathSpec");
        Assertions.assertEquals((int)-1, (int)spec.getPathDepth(), (String)"Spec.pathDepth");
    }

    @Test
    public void testExactPathSpec() {
        ServletPathSpec spec = new ServletPathSpec("/abs/path");
        Assertions.assertEquals((Object)"/abs/path", (Object)spec.getDeclaration(), (String)"Spec.pathSpec");
        Assertions.assertEquals((int)2, (int)spec.getPathDepth(), (String)"Spec.pathDepth");
        this.assertMatches(spec, "/abs/path");
        this.assertNotMatches(spec, "/abs/path/");
        this.assertNotMatches(spec, "/abs/path/more");
        this.assertNotMatches(spec, "/foo");
        this.assertNotMatches(spec, "/foo/abs/path");
        this.assertNotMatches(spec, "/foo/abs/path/");
    }

    @Test
    public void testGetPathInfo() {
        ServletPathSpec spec = new ServletPathSpec("/Foo/bar");
        MatcherAssert.assertThat((String)"PathInfo exact", (Object)spec.matched("/Foo/bar").getPathInfo(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        spec = new ServletPathSpec("/Foo/*");
        MatcherAssert.assertThat((String)"PathInfo prefix", (Object)spec.matched("/Foo/bar").getPathInfo(), (Matcher)Matchers.is((Object)"/bar"));
        MatcherAssert.assertThat((String)"PathInfo prefix", (Object)spec.matched("/Foo/*").getPathInfo(), (Matcher)Matchers.is((Object)"/*"));
        MatcherAssert.assertThat((String)"PathInfo prefix", (Object)spec.matched("/Foo/").getPathInfo(), (Matcher)Matchers.is((Object)"/"));
        MatcherAssert.assertThat((String)"PathInfo prefix", (Object)spec.matched("/Foo").getPathInfo(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        spec = new ServletPathSpec("*.ext");
        MatcherAssert.assertThat((String)"PathInfo suffix", (Object)spec.matched("/Foo/bar.ext").getPathInfo(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        spec = new ServletPathSpec("/");
        MatcherAssert.assertThat((String)"PathInfo default", (Object)spec.matched("/Foo/bar.ext").getPathInfo(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        spec = new ServletPathSpec("");
        MatcherAssert.assertThat((String)"PathInfo root", (Object)spec.matched("/").getPathInfo(), (Matcher)Matchers.is((Object)"/"));
        MatcherAssert.assertThat((String)"PathInfo root", (Object)spec.matched(""), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        spec = new ServletPathSpec("/*");
        MatcherAssert.assertThat((String)"PathInfo default", (Object)spec.matched("/xxx/zzz").getPathInfo(), (Matcher)Matchers.is((Object)"/xxx/zzz"));
    }

    @Test
    public void testNullPathSpec() {
        ServletPathSpec spec = new ServletPathSpec(null);
        Assertions.assertEquals((Object)"", (Object)spec.getDeclaration(), (String)"Spec.pathSpec");
        Assertions.assertEquals((int)-1, (int)spec.getPathDepth(), (String)"Spec.pathDepth");
    }

    @Test
    public void testRootPathSpec() {
        ServletPathSpec spec = new ServletPathSpec("");
        Assertions.assertEquals((Object)"", (Object)spec.getDeclaration(), (String)"Spec.pathSpec");
        Assertions.assertEquals((int)-1, (int)spec.getPathDepth(), (String)"Spec.pathDepth");
    }

    @Test
    public void testPathMatch() {
        ServletPathSpec spec = new ServletPathSpec("/Foo/bar");
        MatcherAssert.assertThat((String)"PathMatch exact", (Object)spec.matched("/Foo/bar").getPathMatch(), (Matcher)Matchers.is((Object)"/Foo/bar"));
        spec = new ServletPathSpec("/Foo/*");
        MatcherAssert.assertThat((String)"PathMatch prefix", (Object)spec.matched("/Foo/bar").getPathMatch(), (Matcher)Matchers.is((Object)"/Foo"));
        MatcherAssert.assertThat((String)"PathMatch prefix", (Object)spec.matched("/Foo/").getPathMatch(), (Matcher)Matchers.is((Object)"/Foo"));
        MatcherAssert.assertThat((String)"PathMatch prefix", (Object)spec.matched("/Foo").getPathMatch(), (Matcher)Matchers.is((Object)"/Foo"));
        spec = new ServletPathSpec("*.ext");
        MatcherAssert.assertThat((String)"PathMatch suffix", (Object)spec.matched("/Foo/bar.ext").getPathMatch(), (Matcher)Matchers.is((Object)"/Foo/bar.ext"));
        spec = new ServletPathSpec("/");
        MatcherAssert.assertThat((String)"PathMatch default", (Object)spec.matched("/Foo/bar.ext").getPathMatch(), (Matcher)Matchers.is((Object)"/Foo/bar.ext"));
        spec = new ServletPathSpec("");
        MatcherAssert.assertThat((String)"PathMatch root", (Object)spec.matched("/").getPathMatch(), (Matcher)Matchers.is((Object)""));
        MatcherAssert.assertThat((String)"PathMatch root", (Object)spec.matched(""), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        spec = new ServletPathSpec("/*");
        MatcherAssert.assertThat((String)"PathMatch default", (Object)spec.matched("/xxx/zzz").getPathMatch(), (Matcher)Matchers.is((Object)""));
    }

    @Test
    public void testPrefixPathSpec() {
        ServletPathSpec spec = new ServletPathSpec("/downloads/*");
        Assertions.assertEquals((Object)"/downloads/*", (Object)spec.getDeclaration(), (String)"Spec.pathSpec");
        Assertions.assertEquals((int)2, (int)spec.getPathDepth(), (String)"Spec.pathDepth");
        this.assertMatches(spec, "/downloads/logo.jpg");
        this.assertMatches(spec, "/downloads/distribution.tar.gz");
        this.assertMatches(spec, "/downloads/distribution.tgz");
        this.assertMatches(spec, "/downloads/distribution.zip");
        this.assertMatches(spec, "/downloads");
        MatchedPath matched = spec.matched("/downloads/");
        MatcherAssert.assertThat((String)"matched.pathMatch", (Object)matched.getPathMatch(), (Matcher)Matchers.is((Object)"/downloads"));
        MatcherAssert.assertThat((String)"matched.pathInfo", (Object)matched.getPathInfo(), (Matcher)Matchers.is((Object)"/"));
        matched = spec.matched("/downloads/distribution.zip");
        MatcherAssert.assertThat((String)"matched.pathMatch", (Object)matched.getPathMatch(), (Matcher)Matchers.is((Object)"/downloads"));
        MatcherAssert.assertThat((String)"matched.pathInfo", (Object)matched.getPathInfo(), (Matcher)Matchers.is((Object)"/distribution.zip"));
        matched = spec.matched("/downloads/dist/9.0/distribution.tar.gz");
        MatcherAssert.assertThat((String)"matched.pathMatch", (Object)matched.getPathMatch(), (Matcher)Matchers.is((Object)"/downloads"));
        MatcherAssert.assertThat((String)"matched.pathInfo", (Object)matched.getPathInfo(), (Matcher)Matchers.is((Object)"/dist/9.0/distribution.tar.gz"));
    }

    @Test
    public void testMatches() {
        Assertions.assertTrue((boolean)new ServletPathSpec("/").matches("/anything"), (String)"match /");
        Assertions.assertTrue((boolean)new ServletPathSpec("/*").matches("/anything"), (String)"match /*");
        Assertions.assertTrue((boolean)new ServletPathSpec("/foo").matches("/foo"), (String)"match /foo");
        Assertions.assertFalse((boolean)new ServletPathSpec("/foo").matches("/bar"), (String)"!match /foo");
        Assertions.assertTrue((boolean)new ServletPathSpec("/foo/*").matches("/foo"), (String)"match /foo/*");
        Assertions.assertTrue((boolean)new ServletPathSpec("/foo/*").matches("/foo/"), (String)"match /foo/*");
        Assertions.assertTrue((boolean)new ServletPathSpec("/foo/*").matches("/foo/anything"), (String)"match /foo/*");
        Assertions.assertFalse((boolean)new ServletPathSpec("/foo/*").matches("/bar"), (String)"!match /foo/*");
        Assertions.assertFalse((boolean)new ServletPathSpec("/foo/*").matches("/bar/"), (String)"!match /foo/*");
        Assertions.assertFalse((boolean)new ServletPathSpec("/foo/*").matches("/bar/anything"), (String)"!match /foo/*");
        Assertions.assertTrue((boolean)new ServletPathSpec("*.foo").matches("anything.foo"), (String)"match *.foo");
        Assertions.assertFalse((boolean)new ServletPathSpec("*.foo").matches("anything.bar"), (String)"!match *.foo");
        Assertions.assertTrue((boolean)new ServletPathSpec("/On*").matches("/On*"), (String)"match /On*");
        Assertions.assertFalse((boolean)new ServletPathSpec("/On*").matches("/One"), (String)"!match /One");
        Assertions.assertTrue((boolean)new ServletPathSpec("").matches("/"), (String)"match \"\"");
    }

    @Test
    public void testSuffixPathSpec() {
        ServletPathSpec spec = new ServletPathSpec("*.gz");
        Assertions.assertEquals((Object)"*.gz", (Object)spec.getDeclaration(), (String)"Spec.pathSpec");
        Assertions.assertEquals((int)0, (int)spec.getPathDepth(), (String)"Spec.pathDepth");
        this.assertMatches(spec, "/downloads/distribution.tar.gz");
        this.assertMatches(spec, "/downloads/jetty.log.gz");
        this.assertNotMatches(spec, "/downloads/distribution.zip");
        this.assertNotMatches(spec, "/downloads/distribution.tgz");
        this.assertNotMatches(spec, "/abs/path");
        MatchedPath matched = spec.matched("/downloads/distribution.tar.gz");
        MatcherAssert.assertThat((String)"Suffix.pathMatch", (Object)matched.getPathMatch(), (Matcher)Matchers.is((Object)"/downloads/distribution.tar.gz"));
        MatcherAssert.assertThat((String)"Suffix.pathInfo", (Object)matched.getPathInfo(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testEquals() {
        MatcherAssert.assertThat((Object)new ServletPathSpec("*.gz"), (Matcher)Matchers.equalTo((Object)new ServletPathSpec("*.gz")));
        MatcherAssert.assertThat((Object)new ServletPathSpec("/foo"), (Matcher)Matchers.equalTo((Object)new ServletPathSpec("/foo")));
        MatcherAssert.assertThat((Object)new ServletPathSpec("/foo/bar"), (Matcher)Matchers.equalTo((Object)new ServletPathSpec("/foo/bar")));
        MatcherAssert.assertThat((Object)new ServletPathSpec("*.gz"), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)new ServletPathSpec("*.do"))));
        MatcherAssert.assertThat((Object)new ServletPathSpec("/foo"), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)new ServletPathSpec("/bar"))));
        MatcherAssert.assertThat((Object)new ServletPathSpec("/bar/foo"), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)new ServletPathSpec("/foo/bar"))));
        MatcherAssert.assertThat((Object)new ServletPathSpec("/foo"), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)new RegexPathSpec("/foo"))));
    }
}

