/*
 * Decompiled with CFR 0.152.
 */
package org.h2.java;

import java.util.ArrayList;
import org.h2.java.ClassObj;
import org.h2.java.Expr;
import org.h2.java.JavaParser;
import org.h2.java.Type;

class NewExpr
implements Expr {
    ClassObj type;
    ArrayList<Expr> arrayInitExpr = new ArrayList();

    NewExpr() {
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.arrayInitExpr.size() > 0) {
            if (this.type.isPrimitive) {
                stringBuilder.append("NEW_ARRAY(sizeof(" + this.type + ")");
                stringBuilder.append(", 1 ");
                for (Expr expr : this.arrayInitExpr) {
                    stringBuilder.append("* ").append(expr);
                }
                stringBuilder.append(")");
            } else {
                stringBuilder.append("NEW_OBJ_ARRAY(1 ");
                for (Expr expr : this.arrayInitExpr) {
                    stringBuilder.append("* ").append(expr);
                }
                stringBuilder.append(")");
            }
        } else {
            stringBuilder.append("NEW_OBJ(" + this.type.id + ", " + JavaParser.toC(this.type.toString()) + ")");
        }
        return stringBuilder.toString();
    }

    public Type getType() {
        Type type = new Type();
        type.classObj = this.type;
        type.arrayLevel = this.arrayInitExpr.size();
        return type;
    }
}

