/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.test.jupiter;

import java.lang.reflect.Method;
import org.eclipse.jetty.toolchain.test.StringMangler;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class TestTrackerExtension
implements BeforeEachCallback {
    public void beforeEach(ExtensionContext extensionContext) {
        Boolean logDisplay = Boolean.getBoolean("jetty.testtracker.log");
        if (logDisplay.booleanValue()) {
            Method method = extensionContext.getRequiredTestMethod();
            Class clazz = extensionContext.getRequiredTestClass();
            if (method.getParameterCount() > 0) {
                String displayName = extensionContext.getDisplayName();
                if (displayName.contains(method.getName())) {
                    System.err.printf("Running %s.%s%n", clazz.getName(), StringMangler.escapeJava(displayName));
                } else {
                    System.err.printf("Running %s.%s(%s)%n", clazz.getName(), method.getName(), StringMangler.escapeJava(displayName));
                }
            } else {
                System.err.printf("Running %s.%s()%n", clazz.getName(), method.getName());
            }
        }
    }
}

