/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.issue;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class LBCORE97 {
    static int THREAD_COUNT = 10;

    public static void main(String[] args) throws InterruptedException {
        System.out.println("Environment:");
        System.out.println("java.runtime.name    = " + System.getProperty("java.runtime.name"));
        System.out.println("java.runtime.version = " + System.getProperty("java.runtime.version"));
        System.out.println("java.vendor          = " + System.getProperty("java.vendor"));
        System.out.println("java.version         = " + System.getProperty("java.version"));
        System.out.println("java.vm.name         = " + System.getProperty("java.vm.name"));
        System.out.println("java.vm.info         = " + System.getProperty("java.vm.info"));
        System.out.println("os.name              = " + System.getProperty("os.name"));
        System.out.println("os.version           = " + System.getProperty("os.version"));
        System.out.println("os.arch              = " + System.getProperty("os.arch"));
        System.out.println("##########################################");
        LBCORE97.usingSynchronized(THREAD_COUNT);
        LBCORE97.usingUnfairLock(THREAD_COUNT);
        LBCORE97.usingFairLock(THREAD_COUNT);
    }

    public static void execute(String text, Thread[] threads) throws InterruptedException {
        int i;
        System.out.println("About to execute " + text + "...");
        int threadCount = threads.length;
        for (i = 0; i < threadCount; ++i) {
            threads[i].start();
        }
        Thread.sleep(10000L);
        for (i = 0; i < threadCount; ++i) {
            threads[i].interrupt();
        }
        Thread.sleep(1000L);
    }

    public static void print(String text, Runnable[] runnables) {
        System.out.println("Results for " + text + ":");
        for (int i = 0; i < runnables.length; ++i) {
            System.out.println("runnables[" + i + "]: " + runnables[i]);
        }
        System.out.println("##########################################");
    }

    public static void usingSynchronized(int threadCount) throws InterruptedException {
        Object lockObject = new Object();
        Runnable[] runnables = new Runnable[threadCount];
        Thread[] threads = new Thread[threadCount];
        for (int i = 0; i < threadCount; ++i) {
            runnables[i] = new SynchronizedRunnable(lockObject);
            threads[i] = new Thread(runnables[i]);
        }
        String text = "usingSynchronized";
        LBCORE97.execute(text, threads);
        LBCORE97.print(text, runnables);
    }

    public static void usingUnfairLock(int threadCount) throws InterruptedException {
        ReentrantLock lock = new ReentrantLock();
        Runnable[] runnables = new Runnable[threadCount];
        Thread[] threads = new Thread[threadCount];
        for (int i = 0; i < threadCount; ++i) {
            runnables[i] = new LockRunnable(lock);
            threads[i] = new Thread(runnables[i]);
        }
        String text = "usingUnfairLock";
        LBCORE97.execute(text, threads);
        LBCORE97.print(text, runnables);
    }

    public static void usingFairLock(int threadCount) throws InterruptedException {
        ReentrantLock lock = new ReentrantLock(true);
        Runnable[] runnables = new Runnable[threadCount];
        Thread[] threads = new Thread[threadCount];
        for (int i = 0; i < threadCount; ++i) {
            runnables[i] = new LockRunnable(lock);
            threads[i] = new Thread(runnables[i]);
        }
        String text = "usingFairLock";
        LBCORE97.execute(text, threads);
        LBCORE97.print(text, runnables);
    }

    public static class LockRunnable
    implements Runnable {
        private final Lock lock;
        private int counter;
        private boolean running;

        public LockRunnable(Lock lock) {
            this.lock = lock;
            this.counter = 0;
            this.running = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.running = true;
            while (true) {
                this.lock.lock();
                try {
                    ++this.counter;
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException ex) {
                }
                finally {
                    this.lock.unlock();
                    continue;
                }
                break;
            }
            this.running = false;
        }

        public String toString() {
            return "LockRunnable[counter=" + this.counter + ", running=" + this.running + "]";
        }
    }

    public static class SynchronizedRunnable
    implements Runnable {
        private final Object lockObject;
        private int counter;
        private boolean running;

        public SynchronizedRunnable(Object lockObject) {
            this.lockObject = lockObject;
            this.counter = 0;
            this.running = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.running = true;
            while (true) {
                Object object = this.lockObject;
                synchronized (object) {
                    ++this.counter;
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException ex) {
                        break;
                    }
                }
            }
            this.running = false;
        }

        public String toString() {
            return "SynchronizedRunnable[counter=" + this.counter + ", running=" + this.running + "]";
        }
    }
}

