/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.tests.utils.impl;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.powermock.core.classloader.annotations.PowerMockListener;
import org.powermock.core.reporter.MockingFrameworkReporterFactory;
import org.powermock.core.spi.PowerMockTestListener;
import org.powermock.reflect.Whitebox;
import org.powermock.tests.utils.RunnerTestSuiteChunker;
import org.powermock.tests.utils.TestChunk;
import org.powermock.tests.utils.impl.AbstractCommonTestSuiteChunkerImpl;

public abstract class AbstractTestSuiteChunkerImpl<T>
extends AbstractCommonTestSuiteChunkerImpl
implements RunnerTestSuiteChunker {
    protected final Set<Class<?>> delegatesCreatedForTheseClasses = new LinkedHashSet();
    protected final List<T> delegates = new ArrayList<T>();
    protected volatile int testCount = -1;

    protected AbstractTestSuiteChunkerImpl(Class<?> testClass) throws Exception {
        super(testClass);
    }

    protected AbstractTestSuiteChunkerImpl(Class<?> ... testClasses) throws Exception {
        super(testClasses);
    }

    protected Object getPowerMockTestListenersLoadedByASpecificClassLoader(Class<?> clazz, ClassLoader classLoader) {
        try {
            int defaultListenerSize = 1;
            Class<?> annotationEnablerClass = null;
            try {
                annotationEnablerClass = Class.forName("org.powermock.api.extension.listener.AnnotationEnabler", false, classLoader);
            }
            catch (ClassNotFoundException e) {
                defaultListenerSize = 0;
            }
            this.registerProxyframework(classLoader);
            Class<?> powerMockTestListenerType = Class.forName(PowerMockTestListener.class.getName(), false, classLoader);
            Object testListeners = null;
            if (clazz.isAnnotationPresent(PowerMockListener.class)) {
                PowerMockListener annotation = clazz.getAnnotation(PowerMockListener.class);
                Class<? extends PowerMockTestListener>[] powerMockTestListeners = annotation.value();
                if (powerMockTestListeners.length > 0) {
                    testListeners = Array.newInstance(powerMockTestListenerType, powerMockTestListeners.length + defaultListenerSize);
                    for (int i = 0; i < powerMockTestListeners.length; ++i) {
                        String testListenerClassName = powerMockTestListeners[i].getName();
                        Class<?> listenerTypeLoadedByClassLoader = Class.forName(testListenerClassName, false, classLoader);
                        Array.set(testListeners, i, Whitebox.newInstance(listenerTypeLoadedByClassLoader));
                    }
                }
            } else {
                testListeners = Array.newInstance(powerMockTestListenerType, defaultListenerSize);
            }
            if (annotationEnablerClass != null) {
                Array.set(testListeners, Array.getLength(testListeners) - 1, Whitebox.newInstance(annotationEnablerClass));
            }
            return testListeners;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("PowerMock internal error: Failed to load class.", e);
        }
    }

    @Override
    public final void createTestDelegators(Class<?> testClass, List<TestChunk> chunks) throws Exception {
        for (TestChunk chunk : chunks) {
            ClassLoader classLoader = chunk.getClassLoader();
            List<Method> methodsToTest = chunk.getTestMethodsToBeExecutedByThisClassloader();
            T runnerDelegator = this.createDelegatorFromClassloader(classLoader, testClass, methodsToTest);
            this.delegates.add(runnerDelegator);
        }
        this.delegatesCreatedForTheseClasses.add(testClass);
    }

    protected abstract T createDelegatorFromClassloader(ClassLoader var1, Class<?> var2, List<Method> var3) throws Exception;

    public int getInternalTestIndex(int originalTestIndex) {
        Set delegatorEntrySet = this.testAtDelegateMapper.entrySet();
        for (Map.Entry entry : delegatorEntrySet) {
            List testIndexesForThisDelegate = (List)entry.getValue();
            int internalIndex = testIndexesForThisDelegate.indexOf(originalTestIndex);
            if (internalIndex == -1) continue;
            return internalIndex;
        }
        return -1;
    }

    public int getDelegatorIndex(int testIndex) {
        int delegatorIndex = -1;
        Set entrySet = this.testAtDelegateMapper.entrySet();
        for (Map.Entry entry : entrySet) {
            if (!((List)entry.getValue()).contains(testIndex)) continue;
            delegatorIndex = (Integer)entry.getKey();
            break;
        }
        if (delegatorIndex == -1) {
            throw new RuntimeException("Internal error: Failed to find the delgator index.");
        }
        return delegatorIndex;
    }

    public Class<?>[] getTestClasses() {
        return this.testClasses;
    }

    protected MockingFrameworkReporterFactory getFrameworkReporterFactory() {
        Class<?> mockingFrameworkReporterFactoryClass;
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            mockingFrameworkReporterFactoryClass = classLoader.loadClass("org.powermock.api.extension.reporter.MockingFrameworkReporterFactoryImpl");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Extension API internal error: org.powermock.api.extension.reporter.MockingFrameworkReporterFactoryImpl could not be located in classpath.");
        }
        return (MockingFrameworkReporterFactory)Whitebox.newInstance(mockingFrameworkReporterFactoryClass);
    }
}

