// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanSatchelMegalistMetrics_h
#define mozilla_GleanSatchelMegalistMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace contextual_manager {
  /**
   * generated from contextual_manager.notification_interaction
   */
  struct NotificationInteractionExtra {
    mozilla::Maybe<nsCString> actionType;
    mozilla::Maybe<nsCString> notificationDetail;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (actionType) {
        extraKeys.AppendElement()->AssignASCII("action_type");
        extraValues.EmplaceBack(actionType.value());
      }
      if (notificationDetail) {
        extraKeys.AppendElement()->AssignASCII("notification_detail");
        extraValues.EmplaceBack(notificationDetail.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Client interacts with displayed notification Possible notification details include:
   *   "import_success": Logins were successfully imported
   *   "import_error": There was an error importing logins
   *   "export_passwords_success": Logins were successfully exported
   *   "add_login_success": A login was successfully added manually
   *   "update_login_success": A login was succesfully updated manually
   *   "delete_login_success": Logins were successfully deleted
   *   "discard_changes": Exited the login form while updating
   *   "login_already_exists_warning": A login was not created because it already exists
   *   "breached_origin_warning": A login has a breached origin alert
   *   "vulnerable_password_warning": A login has a vulnerable password alert
   *   "no_username_warning": A login has a no username alert
   * Possible action types include:
   *   "change_record": Change a record field
   *   "open_link": Open a link
   *   "import": Import records after a failed attempt
   *   "confirm_discard_changes": Continue exiting the login form while updating
   *   "nav_record": Navigate to a newly created or existing record
   *   "dismiss": Close a notification
   */
  constexpr impl::EventMetric<NotificationInteractionExtra> notification_interaction(832);

  /**
   * generated from contextual_manager.notification_shown
   */
  struct NotificationShownExtra {
    mozilla::Maybe<nsCString> notificationDetail;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (notificationDetail) {
        extraKeys.AppendElement()->AssignASCII("notification_detail");
        extraValues.EmplaceBack(notificationDetail.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Notification is dislayed to client. Possible notification details include:
   *   "import_success": Logins were successfully imported
   *   "import_error": There was an error importing logins
   *   "export_passwords_success": Logins were successfully exported
   *   "add_login_success": A login was successfully added manually
   *   "update_login_success": A login was succesfully updated manually
   *   "delete_login_success": Logins were successfully deleted
   *   "discard_changes": Exited the login form while updating
   *   "login_already_exists_warning": A login was not created because it already exists
   *   "breached_origin_warning": A login has a breached origin alert
   *   "vulnerable_password_warning": A login has a vulnerable password alert
   *   "no_username_warning": A login has a no username alert
   */
  constexpr impl::EventMetric<NotificationShownExtra> notification_shown(833);

  /**
   * generated from contextual_manager.records_interaction
   */
  struct RecordsInteractionExtra {
    mozilla::Maybe<nsCString> interactionType;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (interactionType) {
        extraKeys.AppendElement()->AssignASCII("interaction_type");
        extraValues.EmplaceBack(interactionType.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Client interacts with existing CM tile Possible interaction types include:
   *   "url_navigate": When the origin field is clicked
   *   "copy_username": When the username field is clicked
   *   "copy_password": When the password field is clicked
   *   "view_password": When the reveal password button is clicked
   *   "hide_password": When the hide password button is clicked
   *   "edit": When the edit button is clicked
   *   "view_alert": When the "View alert" button is clicked
   */
  constexpr impl::EventMetric<RecordsInteractionExtra> records_interaction(834);

  /**
   * generated from contextual_manager.records_update
   */
  struct RecordsUpdateExtra {
    mozilla::Maybe<nsCString> changeType;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (changeType) {
        extraKeys.AppendElement()->AssignASCII("change_type");
        extraValues.EmplaceBack(changeType.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Client modifies, adds, or removes CM record. Captures changes committed to a client's password management records. Possible change types:
   *   "add": Single record is created
   *   "edit": Single record is edited
   *   "remove": Single record is removed
   *   "remove_all": All records are removed
   *   "import": Records were changed by importing from another dataset
   *             (such as a file, browser)
   */
  constexpr impl::EventMetric<RecordsUpdateExtra> records_update(835);

  /**
   * generated from contextual_manager.toolbar_action
   */
  struct ToolbarActionExtra {
    mozilla::Maybe<nsCString> optionName;
    mozilla::Maybe<nsCString> trigger;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (optionName) {
        extraKeys.AppendElement()->AssignASCII("option_name");
        extraValues.EmplaceBack(optionName.value());
      }
      if (trigger) {
        extraKeys.AppendElement()->AssignASCII("trigger");
        extraValues.EmplaceBack(trigger.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Client interacts with any object within CM toolbar, or any action associated with the toolbar is initiated from an "empty state". Possible triggers include:
   *   "empty_state_card": When there are no records stored and user is presented
   *                       options for a user to take
   *   "toolbar": When the user selects an option from the CPM toolbar
   * Possible option names include:
   *   "add_new": Add a new record
   *   "import_browser": Import records from another browser
   *   "import_file": Import records from a file
   *   "export": Export records to a file
   *   "remove_all": Remove all records
   *   "preferences": Takes user to about:preferences
   *   "help": Takes user to a SUMO page
   *   "list_state_all": Display all records
   *   "list_state_alerts": Display only alerts
   */
  constexpr impl::EventMetric<ToolbarActionExtra> toolbar_action(836);
}

} // namespace mozilla::glean

#endif // mozilla_GleanSatchelMegalistMetrics_h
