/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/xpcom/threads/nsITimer.idl
 */

#ifndef __gen_nsITimer_h__
#define __gen_nsITimer_h__


#include "nsISupports.h"

#include "nsINamed.h"

#include "nsTArray.h"

#include "js/GCAnnotations.h"

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIObserver; /* forward declaration */

class nsIEventTarget; /* forward declaration */

#include "mozilla/MemoryReporting.h"
#include "mozilla/TimeStamp.h"
#include <functional>
/**
 * The signature of the timer callback function passed to
 * initWithNamedFuncCallback and similar functions. This is the function that
 * will get called when the timer expires if the timer is initialized via
 * initWithNamedFuncCallback.
 *
 * @param aTimer the timer which has expired
 * @param aClosure opaque parameter passed to initWithNamedFuncCallback
 */
class nsITimer;
typedef void (*nsTimerCallbackFunc) (nsITimer* aTimer, void* aClosure);
class nsITimer; /* forward declaration */


/* starting interface:    nsITimerCallback */
#define NS_ITIMERCALLBACK_IID_STR "a796816d-7d47-4348-9ab8-c7aeb3216a7d"

#define NS_ITIMERCALLBACK_IID \
  {0xa796816d, 0x7d47, 0x4348, \
    { 0x9a, 0xb8, 0xc7, 0xae, 0xb3, 0x21, 0x6a, 0x7d }}

class NS_NO_VTABLE nsITimerCallback : public nsISupports {
 public:

  NS_INLINE_DECL_STATIC_IID(NS_ITIMERCALLBACK_IID)

  /* Used by ToJSValue to check which scriptable interface is implemented. */
  using ScriptableInterfaceType = nsITimerCallback;

  /* void notify (in nsITimer timer); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD Notify(nsITimer *timer) = 0;

};


/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSITIMERCALLBACK \
  NS_IMETHOD Notify(nsITimer *timer) override; 

/* Use this macro when declaring the members of this interface when the
   class doesn't implement the interface. This is useful for forwarding. */
#define NS_DECL_NON_VIRTUAL_NSITIMERCALLBACK \
  nsresult Notify(nsITimer *timer); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSITIMERCALLBACK(_to) \
  NS_IMETHOD Notify(nsITimer *timer) override { return _to Notify(timer); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSITIMERCALLBACK(_to) \
  NS_IMETHOD Notify(nsITimer *timer) override { return !_to ? NS_ERROR_NULL_POINTER : _to->Notify(timer); } 

// Two timer deadlines must differ by less than half the PRIntervalTime domain.
#define DELAY_INTERVAL_LIMIT    PR_BIT(8 * sizeof(PRIntervalTime) - 1)

/* starting interface:    nsITimer */
#define NS_ITIMER_IID_STR "3de4b105-363c-482c-a409-baac83a01bfc"

#define NS_ITIMER_IID \
  {0x3de4b105, 0x363c, 0x482c, \
    { 0xa4, 0x09, 0xba, 0xac, 0x83, 0xa0, 0x1b, 0xfc }}

class NS_NO_VTABLE nsITimer : public nsISupports {
 public:

  NS_INLINE_DECL_STATIC_IID(NS_ITIMER_IID)

  /* Used by ToJSValue to check which scriptable interface is implemented. */
  using ScriptableInterfaceType = nsITimer;

  enum {
    TYPE_ONE_SHOT = 0,
    TYPE_REPEATING_SLACK = 1,
    TYPE_REPEATING_PRECISE = 2,
    TYPE_REPEATING_PRECISE_CAN_SKIP = 3,
    TYPE_REPEATING_SLACK_LOW_PRIORITY = 4,
    TYPE_ONE_SHOT_LOW_PRIORITY = 5
  };

  /* void init (in nsIObserver aObserver, in unsigned long aDelayInMs, in unsigned long aType); */
  NS_IMETHOD Init(nsIObserver *aObserver, uint32_t aDelayInMs, uint32_t aType) = 0;

  /* void initWithCallback (in nsITimerCallback aCallback, in unsigned long aDelayInMs, in unsigned long aType); */
  NS_IMETHOD InitWithCallback(nsITimerCallback *aCallback, uint32_t aDelayInMs, uint32_t aType) = 0;

  /* [noscript] void initHighResolutionWithCallback (in nsITimerCallback aCallback, [const] in TimeDuration aDelay, in unsigned long aType); */
  NS_IMETHOD InitHighResolutionWithCallback(nsITimerCallback *aCallback, const mozilla::TimeDuration & aDelay, uint32_t aType) = 0;

  /* void cancel (); */
  NS_IMETHOD Cancel(void) = 0;

  /* [noscript] void initWithNamedFuncCallback (in nsTimerCallbackFunc aCallback, in voidPtr aClosure, in unsigned long aDelay, in unsigned long aType, in string aName); */
  NS_IMETHOD InitWithNamedFuncCallback(nsTimerCallbackFunc aCallback, void * aClosure, uint32_t aDelay, uint32_t aType, const char * aName) = 0;

  /* [noscript] void initHighResolutionWithNamedFuncCallback (in nsTimerCallbackFunc aCallback, in voidPtr aClosure, [const] in TimeDuration aDelay, in unsigned long aType, in string aName); */
  NS_IMETHOD InitHighResolutionWithNamedFuncCallback(nsTimerCallbackFunc aCallback, void * aClosure, const mozilla::TimeDuration & aDelay, uint32_t aType, const char * aName) = 0;

  /* attribute unsigned long delay; */
  NS_IMETHOD GetDelay(uint32_t *aDelay) = 0;
  NS_IMETHOD SetDelay(uint32_t aDelay) = 0;

  /* attribute unsigned long type; */
  NS_IMETHOD GetType(uint32_t *aType) = 0;
  NS_IMETHOD SetType(uint32_t aType) = 0;

  /* [noscript] readonly attribute voidPtr closure; */
  NS_IMETHOD GetClosure(void * * aClosure) = 0;

  /* readonly attribute nsITimerCallback callback; */
  NS_IMETHOD GetCallback(nsITimerCallback **aCallback) = 0;

  /* attribute nsIEventTarget target; */
  NS_IMETHOD GetTarget(nsIEventTarget **aTarget) = 0;
  NS_IMETHOD SetTarget(nsIEventTarget *aTarget) = 0;

  /* readonly attribute ACString name; */
  NS_IMETHOD GetName(nsACString& aName) = 0;

  /* [noscript] readonly attribute unsigned long allowedEarlyFiringMicroseconds; */
  NS_IMETHOD GetAllowedEarlyFiringMicroseconds(uint32_t *aAllowedEarlyFiringMicroseconds) = 0;

  /* [nostdcall,notxpcom] size_t sizeOfIncludingThis (in MallocSizeOf aMallocSizeOf); */
  virtual size_t SizeOfIncludingThis(mozilla::MallocSizeOf aMallocSizeOf) = 0;

};


/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSITIMER \
  NS_IMETHOD Init(nsIObserver *aObserver, uint32_t aDelayInMs, uint32_t aType) override; \
  NS_IMETHOD InitWithCallback(nsITimerCallback *aCallback, uint32_t aDelayInMs, uint32_t aType) override; \
  NS_IMETHOD InitHighResolutionWithCallback(nsITimerCallback *aCallback, const mozilla::TimeDuration & aDelay, uint32_t aType) override; \
  NS_IMETHOD Cancel(void) override; \
  NS_IMETHOD InitWithNamedFuncCallback(nsTimerCallbackFunc aCallback, void * aClosure, uint32_t aDelay, uint32_t aType, const char * aName) override; \
  NS_IMETHOD InitHighResolutionWithNamedFuncCallback(nsTimerCallbackFunc aCallback, void * aClosure, const mozilla::TimeDuration & aDelay, uint32_t aType, const char * aName) override; \
  NS_IMETHOD GetDelay(uint32_t *aDelay) override; \
  NS_IMETHOD SetDelay(uint32_t aDelay) override; \
  NS_IMETHOD GetType(uint32_t *aType) override; \
  NS_IMETHOD SetType(uint32_t aType) override; \
  NS_IMETHOD GetClosure(void * * aClosure) override; \
  NS_IMETHOD GetCallback(nsITimerCallback **aCallback) override; \
  NS_IMETHOD GetTarget(nsIEventTarget **aTarget) override; \
  NS_IMETHOD SetTarget(nsIEventTarget *aTarget) override; \
  NS_IMETHOD GetName(nsACString& aName) override; \
  NS_IMETHOD GetAllowedEarlyFiringMicroseconds(uint32_t *aAllowedEarlyFiringMicroseconds) override; \
  virtual size_t SizeOfIncludingThis(mozilla::MallocSizeOf aMallocSizeOf) override; 

/* Use this macro when declaring the members of this interface when the
   class doesn't implement the interface. This is useful for forwarding. */
#define NS_DECL_NON_VIRTUAL_NSITIMER \
  nsresult Init(nsIObserver *aObserver, uint32_t aDelayInMs, uint32_t aType); \
  nsresult InitWithCallback(nsITimerCallback *aCallback, uint32_t aDelayInMs, uint32_t aType); \
  nsresult InitHighResolutionWithCallback(nsITimerCallback *aCallback, const mozilla::TimeDuration & aDelay, uint32_t aType); \
  nsresult Cancel(void); \
  nsresult InitWithNamedFuncCallback(nsTimerCallbackFunc aCallback, void * aClosure, uint32_t aDelay, uint32_t aType, const char * aName); \
  nsresult InitHighResolutionWithNamedFuncCallback(nsTimerCallbackFunc aCallback, void * aClosure, const mozilla::TimeDuration & aDelay, uint32_t aType, const char * aName); \
  nsresult GetDelay(uint32_t *aDelay); \
  nsresult SetDelay(uint32_t aDelay); \
  nsresult GetType(uint32_t *aType); \
  nsresult SetType(uint32_t aType); \
  nsresult GetClosure(void * * aClosure); \
  nsresult GetCallback(nsITimerCallback **aCallback); \
  nsresult GetTarget(nsIEventTarget **aTarget); \
  nsresult SetTarget(nsIEventTarget *aTarget); \
  nsresult GetName(nsACString& aName); \
  nsresult GetAllowedEarlyFiringMicroseconds(uint32_t *aAllowedEarlyFiringMicroseconds); \
  size_t SizeOfIncludingThis(mozilla::MallocSizeOf aMallocSizeOf); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSITIMER(_to) \
  NS_IMETHOD Init(nsIObserver *aObserver, uint32_t aDelayInMs, uint32_t aType) override { return _to Init(aObserver, aDelayInMs, aType); } \
  NS_IMETHOD InitWithCallback(nsITimerCallback *aCallback, uint32_t aDelayInMs, uint32_t aType) override { return _to InitWithCallback(aCallback, aDelayInMs, aType); } \
  NS_IMETHOD InitHighResolutionWithCallback(nsITimerCallback *aCallback, const mozilla::TimeDuration & aDelay, uint32_t aType) override { return _to InitHighResolutionWithCallback(aCallback, aDelay, aType); } \
  NS_IMETHOD Cancel(void) override { return _to Cancel(); } \
  NS_IMETHOD InitWithNamedFuncCallback(nsTimerCallbackFunc aCallback, void * aClosure, uint32_t aDelay, uint32_t aType, const char * aName) override { return _to InitWithNamedFuncCallback(aCallback, aClosure, aDelay, aType, aName); } \
  NS_IMETHOD InitHighResolutionWithNamedFuncCallback(nsTimerCallbackFunc aCallback, void * aClosure, const mozilla::TimeDuration & aDelay, uint32_t aType, const char * aName) override { return _to InitHighResolutionWithNamedFuncCallback(aCallback, aClosure, aDelay, aType, aName); } \
  NS_IMETHOD GetDelay(uint32_t *aDelay) override { return _to GetDelay(aDelay); } \
  NS_IMETHOD SetDelay(uint32_t aDelay) override { return _to SetDelay(aDelay); } \
  NS_IMETHOD GetType(uint32_t *aType) override { return _to GetType(aType); } \
  NS_IMETHOD SetType(uint32_t aType) override { return _to SetType(aType); } \
  NS_IMETHOD GetClosure(void * * aClosure) override { return _to GetClosure(aClosure); } \
  NS_IMETHOD GetCallback(nsITimerCallback **aCallback) override { return _to GetCallback(aCallback); } \
  NS_IMETHOD GetTarget(nsIEventTarget **aTarget) override { return _to GetTarget(aTarget); } \
  NS_IMETHOD SetTarget(nsIEventTarget *aTarget) override { return _to SetTarget(aTarget); } \
  NS_IMETHOD GetName(nsACString& aName) override { return _to GetName(aName); } \
  NS_IMETHOD GetAllowedEarlyFiringMicroseconds(uint32_t *aAllowedEarlyFiringMicroseconds) override { return _to GetAllowedEarlyFiringMicroseconds(aAllowedEarlyFiringMicroseconds); } \
  virtual size_t SizeOfIncludingThis(mozilla::MallocSizeOf aMallocSizeOf) override { return _to SizeOfIncludingThis(aMallocSizeOf); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSITIMER(_to) \
  NS_IMETHOD Init(nsIObserver *aObserver, uint32_t aDelayInMs, uint32_t aType) override { return !_to ? NS_ERROR_NULL_POINTER : _to->Init(aObserver, aDelayInMs, aType); } \
  NS_IMETHOD InitWithCallback(nsITimerCallback *aCallback, uint32_t aDelayInMs, uint32_t aType) override { return !_to ? NS_ERROR_NULL_POINTER : _to->InitWithCallback(aCallback, aDelayInMs, aType); } \
  NS_IMETHOD InitHighResolutionWithCallback(nsITimerCallback *aCallback, const mozilla::TimeDuration & aDelay, uint32_t aType) override { return !_to ? NS_ERROR_NULL_POINTER : _to->InitHighResolutionWithCallback(aCallback, aDelay, aType); } \
  NS_IMETHOD Cancel(void) override { return !_to ? NS_ERROR_NULL_POINTER : _to->Cancel(); } \
  NS_IMETHOD InitWithNamedFuncCallback(nsTimerCallbackFunc aCallback, void * aClosure, uint32_t aDelay, uint32_t aType, const char * aName) override { return !_to ? NS_ERROR_NULL_POINTER : _to->InitWithNamedFuncCallback(aCallback, aClosure, aDelay, aType, aName); } \
  NS_IMETHOD InitHighResolutionWithNamedFuncCallback(nsTimerCallbackFunc aCallback, void * aClosure, const mozilla::TimeDuration & aDelay, uint32_t aType, const char * aName) override { return !_to ? NS_ERROR_NULL_POINTER : _to->InitHighResolutionWithNamedFuncCallback(aCallback, aClosure, aDelay, aType, aName); } \
  NS_IMETHOD GetDelay(uint32_t *aDelay) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDelay(aDelay); } \
  NS_IMETHOD SetDelay(uint32_t aDelay) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetDelay(aDelay); } \
  NS_IMETHOD GetType(uint32_t *aType) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetType(aType); } \
  NS_IMETHOD SetType(uint32_t aType) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetType(aType); } \
  NS_IMETHOD GetClosure(void * * aClosure) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetClosure(aClosure); } \
  NS_IMETHOD GetCallback(nsITimerCallback **aCallback) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCallback(aCallback); } \
  NS_IMETHOD GetTarget(nsIEventTarget **aTarget) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetTarget(aTarget); } \
  NS_IMETHOD SetTarget(nsIEventTarget *aTarget) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetTarget(aTarget); } \
  NS_IMETHOD GetName(nsACString& aName) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetName(aName); } \
  NS_IMETHOD GetAllowedEarlyFiringMicroseconds(uint32_t *aAllowedEarlyFiringMicroseconds) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAllowedEarlyFiringMicroseconds(aAllowedEarlyFiringMicroseconds); } \
  virtual size_t SizeOfIncludingThis(mozilla::MallocSizeOf aMallocSizeOf) override; 

#include "nsCOMPtr.h"
already_AddRefed<nsITimer> NS_NewTimer();
already_AddRefed<nsITimer> NS_NewTimer(nsIEventTarget* aTarget);
nsresult
NS_NewTimerWithObserver(nsITimer** aTimer,
                        nsIObserver* aObserver,
                        uint32_t aDelay,
                        uint32_t aType,
                        nsIEventTarget* aTarget = nullptr);
mozilla::Result<nsCOMPtr<nsITimer>, nsresult>
NS_NewTimerWithObserver(nsIObserver* aObserver,
                        uint32_t aDelay,
                        uint32_t aType,
                        nsIEventTarget* aTarget = nullptr);
nsresult
NS_NewTimerWithCallback(nsITimer** aTimer,
                        nsITimerCallback* aCallback,
                        uint32_t aDelay,
                        uint32_t aType,
                        nsIEventTarget* aTarget = nullptr);
mozilla::Result<nsCOMPtr<nsITimer>, nsresult>
NS_NewTimerWithCallback(nsITimerCallback* aCallback,
                        uint32_t aDelay,
                        uint32_t aType,
                        nsIEventTarget* aTarget = nullptr);
nsresult
NS_NewTimerWithCallback(nsITimer** aTimer,
                        nsITimerCallback* aCallback,
                        const mozilla::TimeDuration& aDelay,
                        uint32_t aType,
                        nsIEventTarget* aTarget = nullptr);
mozilla::Result<nsCOMPtr<nsITimer>, nsresult>
NS_NewTimerWithCallback(nsITimerCallback* aCallback,
                        const mozilla::TimeDuration& aDelay,
                        uint32_t aType,
                        nsIEventTarget* aTarget = nullptr);
nsresult
NS_NewTimerWithCallback(nsITimer** aTimer,
                        std::function<void(nsITimer*)>&& aCallback,
                        uint32_t aDelay,
                        uint32_t aType,
                        const char* aNameString,
                        nsIEventTarget* aTarget = nullptr);
mozilla::Result<nsCOMPtr<nsITimer>, nsresult>
NS_NewTimerWithCallback(std::function<void(nsITimer*)>&& aCallback,
                        uint32_t aDelay,
                        uint32_t aType,
                        const char* aNameString,
                        nsIEventTarget* aTarget = nullptr);
nsresult
NS_NewTimerWithCallback(nsITimer** aTimer,
                        std::function<void(nsITimer*)>&& aCallback,
                        const mozilla::TimeDuration& aDelay,
                        uint32_t aType,
                        const char* aNameString,
                        nsIEventTarget* aTarget = nullptr);
mozilla::Result<nsCOMPtr<nsITimer>, nsresult>
NS_NewTimerWithCallback(std::function<void(nsITimer*)>&& aCallback,
                        const mozilla::TimeDuration& aDelay,
                        uint32_t aType,
                        const char* aNameString,
                        nsIEventTarget* aTarget = nullptr);
nsresult
NS_NewTimerWithFuncCallback(nsITimer** aTimer,
                            nsTimerCallbackFunc aCallback,
                            void* aClosure,
                            uint32_t aDelay,
                            uint32_t aType,
                            const char* aNameString,
                            nsIEventTarget* aTarget = nullptr);
mozilla::Result<nsCOMPtr<nsITimer>, nsresult>
NS_NewTimerWithFuncCallback(nsTimerCallbackFunc aCallback,
                            void* aClosure,
                            uint32_t aDelay,
                            uint32_t aType,
                            const char* aNameString,
                            nsIEventTarget* aTarget = nullptr);
nsresult
NS_NewTimerWithFuncCallback(nsITimer** aTimer,
                            nsTimerCallbackFunc aCallback,
                            void* aClosure,
                            const mozilla::TimeDuration& aDelay,
                            uint32_t aType,
                            const char* aNameString,
                            nsIEventTarget* aTarget = nullptr);
mozilla::Result<nsCOMPtr<nsITimer>, nsresult>
NS_NewTimerWithFuncCallback(nsTimerCallbackFunc aCallback,
                            void* aClosure,
                            const mozilla::TimeDuration& aDelay,
                            uint32_t aType,
                            const char* aNameString,
                            nsIEventTarget* aTarget = nullptr);
#define NS_TIMER_CALLBACK_TOPIC "timer-callback"
#ifndef RELEASE_OR_BETA
#undef NS_DECL_NSITIMERCALLBACK
#define NS_DECL_NSITIMERCALLBACK                                        \
  NS_IMETHOD Notify(nsITimer *timer) override;                          \
  inline void _ensure_GetName_exists(void) {                            \
    static_assert(std::is_convertible<decltype(this), nsINamed*>::value, \
                  "nsITimerCallback implementations must also implement nsINamed");     \
  }
#endif

/* starting interface:    nsITimerManager */
#define NS_ITIMERMANAGER_IID_STR "5482506d-1d21-4d08-b01c-95c87e1295ad"

#define NS_ITIMERMANAGER_IID \
  {0x5482506d, 0x1d21, 0x4d08, \
    { 0xb0, 0x1c, 0x95, 0xc8, 0x7e, 0x12, 0x95, 0xad }}

class NS_NO_VTABLE nsITimerManager : public nsISupports {
 public:

  NS_INLINE_DECL_STATIC_IID(NS_ITIMERMANAGER_IID)

  /* Used by ToJSValue to check which scriptable interface is implemented. */
  using ScriptableInterfaceType = nsITimerManager;

  /* Array<nsITimer> getTimers (); */
  NS_IMETHOD GetTimers(nsTArray<RefPtr<nsITimer>>& _retval) = 0;

};


/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSITIMERMANAGER \
  NS_IMETHOD GetTimers(nsTArray<RefPtr<nsITimer>>& _retval) override; 

/* Use this macro when declaring the members of this interface when the
   class doesn't implement the interface. This is useful for forwarding. */
#define NS_DECL_NON_VIRTUAL_NSITIMERMANAGER \
  nsresult GetTimers(nsTArray<RefPtr<nsITimer>>& _retval); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSITIMERMANAGER(_to) \
  NS_IMETHOD GetTimers(nsTArray<RefPtr<nsITimer>>& _retval) override { return _to GetTimers(_retval); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSITIMERMANAGER(_to) \
  NS_IMETHOD GetTimers(nsTArray<RefPtr<nsITimer>>& _retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetTimers(_retval); } 


#endif /* __gen_nsITimer_h__ */
