/* THIS FILE IS AUTOGENERATED FROM CustomElementRegistry.webidl BY Codegen.py - DO NOT EDIT */

#ifndef DOM_CUSTOMELEMENTREGISTRYBINDING_H_
#define DOM_CUSTOMELEMENTREGISTRYBINDING_H_

#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/EnumTypeTraits.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/CallbackFunction.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/ToJSValue.h"
#include "mozilla/dom/UnionMember.h"
#include "mozilla/dom/UnionTypes.h"
#include "nsCycleCollectionParticipant.h"

namespace mozilla {
namespace dom {

class CustomElementConstructor;
class CustomElementCreationCallback;
class CustomElementRegistry;
class Document;
struct ElementDefinitionOptionsAtoms;
class FileOrUSVStringOrFormData;
struct FormAssociatedLifecycleCallbacksAtoms;
class HTMLFormElement;
class LifecycleAdoptedCallback;
class LifecycleAttributeChangedCallback;
struct LifecycleCallbacksAtoms;
class LifecycleConnectedCallback;
class LifecycleConnectedMoveCallback;
class LifecycleDisconnectedCallback;
class LifecycleFormAssociatedCallback;
class LifecycleFormDisabledCallback;
class LifecycleFormResetCallback;
class LifecycleFormStateRestoreCallback;
class LifecycleGetCustomInterfaceCallback;
struct NativePropertyHooks;
class OwningCustomElementConstructorOrUndefined;
class OwningFileOrUSVStringOrFormData;
class ProtoAndIfaceCache;

} // namespace dom
} // namespace mozilla

namespace mozilla {

namespace dom {

enum class RestoreReason : uint8_t {
  Restore,
  Autocomplete,
};

namespace binding_detail {
template <> struct EnumStrings<RestoreReason> {
  static constexpr nsLiteralCString Values[2] {
    "restore"_ns,
    "autocomplete"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, RestoreReason aArgument, JS::MutableHandle<JS::Value> aValue);


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningCustomElementConstructorOrUndefined& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningCustomElementConstructorOrUndefined& aUnion);


class CustomElementConstructor : public CallbackFunction
{
public:
  explicit inline CustomElementConstructor(JSContext* aCx, JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aCallbackGlobal, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aCallbackGlobal, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline CustomElementConstructor(JSObject* aCallback, JSObject* aCallbackGlobal, const FastCallbackConstructor& )
    : CallbackFunction(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline CustomElementConstructor(JSObject* aCallback, JSObject* aCallbackGlobal, JSObject* aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aCallbackGlobal, aAsyncStack, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline CustomElementConstructor(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  MOZ_CAN_RUN_SCRIPT void Construct(JS::MutableHandle<JS::Value> aRetVal, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr);

  inline bool
  operator==(const CustomElementConstructor& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }
};


namespace binding_detail {
class FastCustomElementConstructor : public CustomElementConstructor
{
public:
  explicit inline FastCustomElementConstructor(JSObject* aCallback, JSObject* aCallbackGlobal)
    : CustomElementConstructor(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    CustomElementConstructor::Trace(aTracer);
  }

  inline void
  FinishSlowJSInitIfMoreThanOneOwner(JSContext* aCx)
  {
    CustomElementConstructor::FinishSlowJSInitIfMoreThanOneOwner(aCx);
  }
};
} // namespace binding_detail


class CustomElementConstructorOrUndefined : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eCustomElementConstructor,
    eUndefined
  };
public:
  enum class Type
  {
    eCustomElementConstructor = TypeOrUninit::eCustomElementConstructor,
    eUndefined = TypeOrUninit::eUndefined
  };

private:
  union Value
  {
    UnionMember<RootedCallback<OwningNonNull<binding_detail::FastCustomElementConstructor>> > mCustomElementConstructor;

  };

  TypeOrUninit mType;
  Value mValue;

  CustomElementConstructorOrUndefined(const CustomElementConstructorOrUndefined&) = delete;
  CustomElementConstructorOrUndefined& operator=(const CustomElementConstructorOrUndefined&) = delete;
public:
  explicit inline CustomElementConstructorOrUndefined()
    : mType(eUninitialized)
  {
  }

  inline ~CustomElementConstructorOrUndefined()
  {
    Uninit();
  }

  [[nodiscard]] inline RootedCallback<OwningNonNull<binding_detail::FastCustomElementConstructor>>&
  RawSetAsCustomElementConstructor(JSContext* cx)
  {
    if (mType == eCustomElementConstructor) {
      return mValue.mCustomElementConstructor.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eCustomElementConstructor;
    return mValue.mCustomElementConstructor.SetValue(cx);
  }

  [[nodiscard]] inline RootedCallback<OwningNonNull<binding_detail::FastCustomElementConstructor>>&
  SetAsCustomElementConstructor(JSContext* cx)
  {
    if (mType == eCustomElementConstructor) {
      return mValue.mCustomElementConstructor.Value();
    }
    Uninit();
    mType = eCustomElementConstructor;
    return mValue.mCustomElementConstructor.SetValue(cx);
  }

  inline bool
  IsCustomElementConstructor() const
  {
    return mType == eCustomElementConstructor;
  }

  inline RootedCallback<OwningNonNull<binding_detail::FastCustomElementConstructor>>&
  GetAsCustomElementConstructor()
  {
    MOZ_RELEASE_ASSERT(IsCustomElementConstructor(), "Wrong type!");
    return mValue.mCustomElementConstructor.Value();
  }

  inline CustomElementConstructor&
  GetAsCustomElementConstructor() const
  {
    MOZ_RELEASE_ASSERT(IsCustomElementConstructor(), "Wrong type!");
    return mValue.mCustomElementConstructor.Value();
  }

  inline bool
  IsUndefined() const
  {
    return mType == eUndefined;
  }

  inline void
  SetUndefined()
  {
    Uninit();
    mType = eUndefined;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eCustomElementConstructor: {
        DestroyCustomElementConstructor();
        break;
      }
      case eUndefined: {
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToCustomElementConstructor(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToCustomElementConstructor(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyCustomElementConstructor()
  {
    MOZ_RELEASE_ASSERT(IsCustomElementConstructor(), "Wrong type!");
    mValue.mCustomElementConstructor.Destroy();
    mType = eUninitialized;
  }
};


class OwningCustomElementConstructorOrUndefined : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningCustomElementConstructorOrUndefined& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eCustomElementConstructor,
    eUndefined
  };
public:
  enum class Type
  {
    eCustomElementConstructor = TypeOrUninit::eCustomElementConstructor,
    eUndefined = TypeOrUninit::eUndefined
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<CustomElementConstructor> > mCustomElementConstructor;

  };

  TypeOrUninit mType;
  Value mValue;

  OwningCustomElementConstructorOrUndefined(const OwningCustomElementConstructorOrUndefined&) = delete;
  OwningCustomElementConstructorOrUndefined& operator=(const OwningCustomElementConstructorOrUndefined&) = delete;
public:
  explicit inline OwningCustomElementConstructorOrUndefined()
    : mType(eUninitialized)
  {
  }

  OwningCustomElementConstructorOrUndefined(OwningCustomElementConstructorOrUndefined&& aOther);

  inline ~OwningCustomElementConstructorOrUndefined()
  {
    Uninit();
  }

  [[nodiscard]] OwningNonNull<CustomElementConstructor>&
  RawSetAsCustomElementConstructor();

  [[nodiscard]] OwningNonNull<CustomElementConstructor>&
  SetAsCustomElementConstructor();

  inline bool
  IsCustomElementConstructor() const
  {
    return mType == eCustomElementConstructor;
  }

  inline OwningNonNull<CustomElementConstructor>&
  GetAsCustomElementConstructor()
  {
    MOZ_RELEASE_ASSERT(IsCustomElementConstructor(), "Wrong type!");
    return mValue.mCustomElementConstructor.Value();
  }

  inline OwningNonNull<CustomElementConstructor> const &
  GetAsCustomElementConstructor() const
  {
    MOZ_RELEASE_ASSERT(IsCustomElementConstructor(), "Wrong type!");
    return mValue.mCustomElementConstructor.Value();
  }

  inline bool
  IsUndefined() const
  {
    return mType == eUndefined;
  }

  inline void
  SetUndefined()
  {
    Uninit();
    mType = eUndefined;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningCustomElementConstructorOrUndefined&
  operator=(OwningCustomElementConstructorOrUndefined&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

private:
  bool
  TrySetToCustomElementConstructor(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToCustomElementConstructor(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyCustomElementConstructor();
};


class CustomElementCreationCallback : public CallbackFunction
{
public:
  explicit inline CustomElementCreationCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aCallbackGlobal, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aCallbackGlobal, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline CustomElementCreationCallback(JSObject* aCallback, JSObject* aCallbackGlobal, const FastCallbackConstructor& )
    : CallbackFunction(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline CustomElementCreationCallback(JSObject* aCallback, JSObject* aCallbackGlobal, JSObject* aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aCallbackGlobal, aAsyncStack, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline CustomElementCreationCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  inline void
  Call(const T& thisVal, const nsAString& name, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "CustomElementCreationCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetCallContext(), thisValJS, name, aRv);
  }

  inline void
  Call(const nsAString& name, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "CustomElementCreationCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    return Call(s.GetCallContext(), JS::UndefinedHandleValue, name, aRv);
  }

  template <typename T>
  inline void
  Call(const T& thisVal, const nsAString& name, const char* aExecutionReason = nullptr)
  {
    return Call(thisVal, name, IgnoreErrors(), aExecutionReason);
  }

  inline void
  Call(const nsAString& name, const char* aExecutionReason = nullptr)
  {
    return Call(name, IgnoreErrors(), aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const CustomElementCreationCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  void Call(BindingCallContext& cx, JS::Handle<JS::Value> aThisVal, const nsAString& name, ErrorResult& aRv);
};


namespace binding_detail {
class FastCustomElementCreationCallback : public CustomElementCreationCallback
{
public:
  explicit inline FastCustomElementCreationCallback(JSObject* aCallback, JSObject* aCallbackGlobal)
    : CustomElementCreationCallback(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    CustomElementCreationCallback::Trace(aTracer);
  }

  inline void
  FinishSlowJSInitIfMoreThanOneOwner(JSContext* aCx)
  {
    CustomElementCreationCallback::FinishSlowJSInitIfMoreThanOneOwner(aCx);
  }
};
} // namespace binding_detail


struct ElementDefinitionOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mExtends;

  ElementDefinitionOptions();

  explicit inline ElementDefinitionOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  ElementDefinitionOptions(ElementDefinitionOptions&& aOther) = default;

  explicit inline ElementDefinitionOptions(const ElementDefinitionOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  ElementDefinitionOptions&
  operator=(const ElementDefinitionOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, ElementDefinitionOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastElementDefinitionOptions : public ElementDefinitionOptions
{
  inline FastElementDefinitionOptions()
    : ElementDefinitionOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct FormAssociatedLifecycleCallbacks : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<OwningNonNull<LifecycleFormAssociatedCallback>> mFormAssociatedCallback;
  MOZ_INIT_OUTSIDE_CTOR Optional<OwningNonNull<LifecycleFormResetCallback>> mFormResetCallback;
  MOZ_INIT_OUTSIDE_CTOR Optional<OwningNonNull<LifecycleFormDisabledCallback>> mFormDisabledCallback;
  MOZ_INIT_OUTSIDE_CTOR Optional<OwningNonNull<LifecycleFormStateRestoreCallback>> mFormStateRestoreCallback;

  FormAssociatedLifecycleCallbacks();

  explicit inline FormAssociatedLifecycleCallbacks(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  FormAssociatedLifecycleCallbacks(FormAssociatedLifecycleCallbacks&& aOther) = default;

private:
  FormAssociatedLifecycleCallbacks(const FormAssociatedLifecycleCallbacks&) = delete;
  FormAssociatedLifecycleCallbacks& operator=(const FormAssociatedLifecycleCallbacks&) = delete;

  static bool
  InitIds(JSContext* cx, FormAssociatedLifecycleCallbacksAtoms* atomsCache);

public:
  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mFormAssociatedCallback, "mFormAssociatedCallback", aFlags);
    ImplCycleCollectionTraverse(aCallback, mFormResetCallback, "mFormResetCallback", aFlags);
    ImplCycleCollectionTraverse(aCallback, mFormDisabledCallback, "mFormDisabledCallback", aFlags);
    ImplCycleCollectionTraverse(aCallback, mFormStateRestoreCallback, "mFormStateRestoreCallback", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mFormAssociatedCallback);
    ImplCycleCollectionUnlink(mFormResetCallback);
    ImplCycleCollectionUnlink(mFormDisabledCallback);
    ImplCycleCollectionUnlink(mFormStateRestoreCallback);
  }
};

namespace binding_detail {
struct FastFormAssociatedLifecycleCallbacks : public FormAssociatedLifecycleCallbacks
{
  inline FastFormAssociatedLifecycleCallbacks()
    : FormAssociatedLifecycleCallbacks(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class LifecycleAdoptedCallback : public CallbackFunction
{
public:
  explicit inline LifecycleAdoptedCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aCallbackGlobal, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aCallbackGlobal, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline LifecycleAdoptedCallback(JSObject* aCallback, JSObject* aCallbackGlobal, const FastCallbackConstructor& )
    : CallbackFunction(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline LifecycleAdoptedCallback(JSObject* aCallback, JSObject* aCallbackGlobal, JSObject* aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aCallbackGlobal, aAsyncStack, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline LifecycleAdoptedCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  inline void
  Call(const T& thisVal, Document* oldDocument, Document* newDocment, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "LifecycleAdoptedCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetCallContext(), thisValJS, oldDocument, newDocment, aRv);
  }

  inline void
  Call(Document* oldDocument, Document* newDocment, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "LifecycleAdoptedCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    return Call(s.GetCallContext(), JS::UndefinedHandleValue, oldDocument, newDocment, aRv);
  }

  template <typename T>
  inline void
  Call(const T& thisVal, Document* oldDocument, Document* newDocment, const char* aExecutionReason = nullptr)
  {
    return Call(thisVal, oldDocument, newDocment, IgnoreErrors(), aExecutionReason);
  }

  inline void
  Call(Document* oldDocument, Document* newDocment, const char* aExecutionReason = nullptr)
  {
    return Call(oldDocument, newDocment, IgnoreErrors(), aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const LifecycleAdoptedCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  void Call(BindingCallContext& cx, JS::Handle<JS::Value> aThisVal, Document* oldDocument, Document* newDocment, ErrorResult& aRv);
};


namespace binding_detail {
class FastLifecycleAdoptedCallback : public LifecycleAdoptedCallback
{
public:
  explicit inline FastLifecycleAdoptedCallback(JSObject* aCallback, JSObject* aCallbackGlobal)
    : LifecycleAdoptedCallback(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    LifecycleAdoptedCallback::Trace(aTracer);
  }

  inline void
  FinishSlowJSInitIfMoreThanOneOwner(JSContext* aCx)
  {
    LifecycleAdoptedCallback::FinishSlowJSInitIfMoreThanOneOwner(aCx);
  }
};
} // namespace binding_detail


class LifecycleAttributeChangedCallback : public CallbackFunction
{
public:
  explicit inline LifecycleAttributeChangedCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aCallbackGlobal, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aCallbackGlobal, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline LifecycleAttributeChangedCallback(JSObject* aCallback, JSObject* aCallbackGlobal, const FastCallbackConstructor& )
    : CallbackFunction(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline LifecycleAttributeChangedCallback(JSObject* aCallback, JSObject* aCallbackGlobal, JSObject* aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aCallbackGlobal, aAsyncStack, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline LifecycleAttributeChangedCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  inline void
  Call(const T& thisVal, const nsAString& attrName, const nsAString& oldValue, const nsAString& newValue, const nsAString& namespaceURI, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "LifecycleAttributeChangedCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetCallContext(), thisValJS, attrName, oldValue, newValue, namespaceURI, aRv);
  }

  inline void
  Call(const nsAString& attrName, const nsAString& oldValue, const nsAString& newValue, const nsAString& namespaceURI, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "LifecycleAttributeChangedCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    return Call(s.GetCallContext(), JS::UndefinedHandleValue, attrName, oldValue, newValue, namespaceURI, aRv);
  }

  template <typename T>
  inline void
  Call(const T& thisVal, const nsAString& attrName, const nsAString& oldValue, const nsAString& newValue, const nsAString& namespaceURI, const char* aExecutionReason = nullptr)
  {
    return Call(thisVal, attrName, oldValue, newValue, namespaceURI, IgnoreErrors(), aExecutionReason);
  }

  inline void
  Call(const nsAString& attrName, const nsAString& oldValue, const nsAString& newValue, const nsAString& namespaceURI, const char* aExecutionReason = nullptr)
  {
    return Call(attrName, oldValue, newValue, namespaceURI, IgnoreErrors(), aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const LifecycleAttributeChangedCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  void Call(BindingCallContext& cx, JS::Handle<JS::Value> aThisVal, const nsAString& attrName, const nsAString& oldValue, const nsAString& newValue, const nsAString& namespaceURI, ErrorResult& aRv);
};


namespace binding_detail {
class FastLifecycleAttributeChangedCallback : public LifecycleAttributeChangedCallback
{
public:
  explicit inline FastLifecycleAttributeChangedCallback(JSObject* aCallback, JSObject* aCallbackGlobal)
    : LifecycleAttributeChangedCallback(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    LifecycleAttributeChangedCallback::Trace(aTracer);
  }

  inline void
  FinishSlowJSInitIfMoreThanOneOwner(JSContext* aCx)
  {
    LifecycleAttributeChangedCallback::FinishSlowJSInitIfMoreThanOneOwner(aCx);
  }
};
} // namespace binding_detail


struct LifecycleCallbacks : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<OwningNonNull<LifecycleConnectedCallback>> mConnectedCallback;
  MOZ_INIT_OUTSIDE_CTOR Optional<OwningNonNull<LifecycleDisconnectedCallback>> mDisconnectedCallback;
  MOZ_INIT_OUTSIDE_CTOR Optional<OwningNonNull<LifecycleConnectedMoveCallback>> mConnectedMoveCallback;
  MOZ_INIT_OUTSIDE_CTOR Optional<OwningNonNull<LifecycleAdoptedCallback>> mAdoptedCallback;
  MOZ_INIT_OUTSIDE_CTOR Optional<OwningNonNull<LifecycleAttributeChangedCallback>> mAttributeChangedCallback;
  MOZ_INIT_OUTSIDE_CTOR Optional<OwningNonNull<LifecycleGetCustomInterfaceCallback>> mGetCustomInterfaceCallback;

  LifecycleCallbacks();

  explicit inline LifecycleCallbacks(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  LifecycleCallbacks(LifecycleCallbacks&& aOther) = default;

private:
  LifecycleCallbacks(const LifecycleCallbacks&) = delete;
  LifecycleCallbacks& operator=(const LifecycleCallbacks&) = delete;

  static bool
  InitIds(JSContext* cx, LifecycleCallbacksAtoms* atomsCache);

public:
  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mConnectedCallback, "mConnectedCallback", aFlags);
    ImplCycleCollectionTraverse(aCallback, mDisconnectedCallback, "mDisconnectedCallback", aFlags);
    ImplCycleCollectionTraverse(aCallback, mConnectedMoveCallback, "mConnectedMoveCallback", aFlags);
    ImplCycleCollectionTraverse(aCallback, mAdoptedCallback, "mAdoptedCallback", aFlags);
    ImplCycleCollectionTraverse(aCallback, mAttributeChangedCallback, "mAttributeChangedCallback", aFlags);
    ImplCycleCollectionTraverse(aCallback, mGetCustomInterfaceCallback, "mGetCustomInterfaceCallback", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mConnectedCallback);
    ImplCycleCollectionUnlink(mDisconnectedCallback);
    ImplCycleCollectionUnlink(mConnectedMoveCallback);
    ImplCycleCollectionUnlink(mAdoptedCallback);
    ImplCycleCollectionUnlink(mAttributeChangedCallback);
    ImplCycleCollectionUnlink(mGetCustomInterfaceCallback);
  }
};

namespace binding_detail {
struct FastLifecycleCallbacks : public LifecycleCallbacks
{
  inline FastLifecycleCallbacks()
    : LifecycleCallbacks(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class LifecycleConnectedCallback : public CallbackFunction
{
public:
  explicit inline LifecycleConnectedCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aCallbackGlobal, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aCallbackGlobal, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline LifecycleConnectedCallback(JSObject* aCallback, JSObject* aCallbackGlobal, const FastCallbackConstructor& )
    : CallbackFunction(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline LifecycleConnectedCallback(JSObject* aCallback, JSObject* aCallbackGlobal, JSObject* aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aCallbackGlobal, aAsyncStack, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline LifecycleConnectedCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  inline void
  Call(const T& thisVal, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "LifecycleConnectedCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetCallContext(), thisValJS, aRv);
  }

  inline void
  Call(ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "LifecycleConnectedCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    return Call(s.GetCallContext(), JS::UndefinedHandleValue, aRv);
  }

  template <typename T>
  inline void
  Call(const T& thisVal, const char* aExecutionReason = nullptr)
  {
    return Call(thisVal, IgnoreErrors(), aExecutionReason);
  }

  inline void
  Call(const char* aExecutionReason = nullptr)
  {
    return Call(IgnoreErrors(), aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const LifecycleConnectedCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  void Call(BindingCallContext& cx, JS::Handle<JS::Value> aThisVal, ErrorResult& aRv);
};


namespace binding_detail {
class FastLifecycleConnectedCallback : public LifecycleConnectedCallback
{
public:
  explicit inline FastLifecycleConnectedCallback(JSObject* aCallback, JSObject* aCallbackGlobal)
    : LifecycleConnectedCallback(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    LifecycleConnectedCallback::Trace(aTracer);
  }

  inline void
  FinishSlowJSInitIfMoreThanOneOwner(JSContext* aCx)
  {
    LifecycleConnectedCallback::FinishSlowJSInitIfMoreThanOneOwner(aCx);
  }
};
} // namespace binding_detail


class LifecycleConnectedMoveCallback : public CallbackFunction
{
public:
  explicit inline LifecycleConnectedMoveCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aCallbackGlobal, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aCallbackGlobal, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline LifecycleConnectedMoveCallback(JSObject* aCallback, JSObject* aCallbackGlobal, const FastCallbackConstructor& )
    : CallbackFunction(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline LifecycleConnectedMoveCallback(JSObject* aCallback, JSObject* aCallbackGlobal, JSObject* aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aCallbackGlobal, aAsyncStack, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline LifecycleConnectedMoveCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  inline void
  Call(const T& thisVal, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "LifecycleConnectedMoveCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetCallContext(), thisValJS, aRv);
  }

  inline void
  Call(ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "LifecycleConnectedMoveCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    return Call(s.GetCallContext(), JS::UndefinedHandleValue, aRv);
  }

  template <typename T>
  inline void
  Call(const T& thisVal, const char* aExecutionReason = nullptr)
  {
    return Call(thisVal, IgnoreErrors(), aExecutionReason);
  }

  inline void
  Call(const char* aExecutionReason = nullptr)
  {
    return Call(IgnoreErrors(), aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const LifecycleConnectedMoveCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  void Call(BindingCallContext& cx, JS::Handle<JS::Value> aThisVal, ErrorResult& aRv);
};


namespace binding_detail {
class FastLifecycleConnectedMoveCallback : public LifecycleConnectedMoveCallback
{
public:
  explicit inline FastLifecycleConnectedMoveCallback(JSObject* aCallback, JSObject* aCallbackGlobal)
    : LifecycleConnectedMoveCallback(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    LifecycleConnectedMoveCallback::Trace(aTracer);
  }

  inline void
  FinishSlowJSInitIfMoreThanOneOwner(JSContext* aCx)
  {
    LifecycleConnectedMoveCallback::FinishSlowJSInitIfMoreThanOneOwner(aCx);
  }
};
} // namespace binding_detail


class LifecycleDisconnectedCallback : public CallbackFunction
{
public:
  explicit inline LifecycleDisconnectedCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aCallbackGlobal, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aCallbackGlobal, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline LifecycleDisconnectedCallback(JSObject* aCallback, JSObject* aCallbackGlobal, const FastCallbackConstructor& )
    : CallbackFunction(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline LifecycleDisconnectedCallback(JSObject* aCallback, JSObject* aCallbackGlobal, JSObject* aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aCallbackGlobal, aAsyncStack, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline LifecycleDisconnectedCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  inline void
  Call(const T& thisVal, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "LifecycleDisconnectedCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetCallContext(), thisValJS, aRv);
  }

  inline void
  Call(ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "LifecycleDisconnectedCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    return Call(s.GetCallContext(), JS::UndefinedHandleValue, aRv);
  }

  template <typename T>
  inline void
  Call(const T& thisVal, const char* aExecutionReason = nullptr)
  {
    return Call(thisVal, IgnoreErrors(), aExecutionReason);
  }

  inline void
  Call(const char* aExecutionReason = nullptr)
  {
    return Call(IgnoreErrors(), aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const LifecycleDisconnectedCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  void Call(BindingCallContext& cx, JS::Handle<JS::Value> aThisVal, ErrorResult& aRv);
};


namespace binding_detail {
class FastLifecycleDisconnectedCallback : public LifecycleDisconnectedCallback
{
public:
  explicit inline FastLifecycleDisconnectedCallback(JSObject* aCallback, JSObject* aCallbackGlobal)
    : LifecycleDisconnectedCallback(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    LifecycleDisconnectedCallback::Trace(aTracer);
  }

  inline void
  FinishSlowJSInitIfMoreThanOneOwner(JSContext* aCx)
  {
    LifecycleDisconnectedCallback::FinishSlowJSInitIfMoreThanOneOwner(aCx);
  }
};
} // namespace binding_detail


class LifecycleFormAssociatedCallback : public CallbackFunction
{
public:
  explicit inline LifecycleFormAssociatedCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aCallbackGlobal, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aCallbackGlobal, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline LifecycleFormAssociatedCallback(JSObject* aCallback, JSObject* aCallbackGlobal, const FastCallbackConstructor& )
    : CallbackFunction(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline LifecycleFormAssociatedCallback(JSObject* aCallback, JSObject* aCallbackGlobal, JSObject* aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aCallbackGlobal, aAsyncStack, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline LifecycleFormAssociatedCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  inline void
  Call(const T& thisVal, HTMLFormElement* form, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "LifecycleFormAssociatedCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetCallContext(), thisValJS, form, aRv);
  }

  inline void
  Call(HTMLFormElement* form, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "LifecycleFormAssociatedCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    return Call(s.GetCallContext(), JS::UndefinedHandleValue, form, aRv);
  }

  template <typename T>
  inline void
  Call(const T& thisVal, HTMLFormElement* form, const char* aExecutionReason = nullptr)
  {
    return Call(thisVal, form, IgnoreErrors(), aExecutionReason);
  }

  inline void
  Call(HTMLFormElement* form, const char* aExecutionReason = nullptr)
  {
    return Call(form, IgnoreErrors(), aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const LifecycleFormAssociatedCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  void Call(BindingCallContext& cx, JS::Handle<JS::Value> aThisVal, HTMLFormElement* form, ErrorResult& aRv);
};


namespace binding_detail {
class FastLifecycleFormAssociatedCallback : public LifecycleFormAssociatedCallback
{
public:
  explicit inline FastLifecycleFormAssociatedCallback(JSObject* aCallback, JSObject* aCallbackGlobal)
    : LifecycleFormAssociatedCallback(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    LifecycleFormAssociatedCallback::Trace(aTracer);
  }

  inline void
  FinishSlowJSInitIfMoreThanOneOwner(JSContext* aCx)
  {
    LifecycleFormAssociatedCallback::FinishSlowJSInitIfMoreThanOneOwner(aCx);
  }
};
} // namespace binding_detail


class LifecycleFormDisabledCallback : public CallbackFunction
{
public:
  explicit inline LifecycleFormDisabledCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aCallbackGlobal, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aCallbackGlobal, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline LifecycleFormDisabledCallback(JSObject* aCallback, JSObject* aCallbackGlobal, const FastCallbackConstructor& )
    : CallbackFunction(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline LifecycleFormDisabledCallback(JSObject* aCallback, JSObject* aCallbackGlobal, JSObject* aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aCallbackGlobal, aAsyncStack, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline LifecycleFormDisabledCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  inline void
  Call(const T& thisVal, bool disabled, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "LifecycleFormDisabledCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetCallContext(), thisValJS, disabled, aRv);
  }

  inline void
  Call(bool disabled, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "LifecycleFormDisabledCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    return Call(s.GetCallContext(), JS::UndefinedHandleValue, disabled, aRv);
  }

  template <typename T>
  inline void
  Call(const T& thisVal, bool disabled, const char* aExecutionReason = nullptr)
  {
    return Call(thisVal, disabled, IgnoreErrors(), aExecutionReason);
  }

  inline void
  Call(bool disabled, const char* aExecutionReason = nullptr)
  {
    return Call(disabled, IgnoreErrors(), aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const LifecycleFormDisabledCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  void Call(BindingCallContext& cx, JS::Handle<JS::Value> aThisVal, bool disabled, ErrorResult& aRv);
};


namespace binding_detail {
class FastLifecycleFormDisabledCallback : public LifecycleFormDisabledCallback
{
public:
  explicit inline FastLifecycleFormDisabledCallback(JSObject* aCallback, JSObject* aCallbackGlobal)
    : LifecycleFormDisabledCallback(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    LifecycleFormDisabledCallback::Trace(aTracer);
  }

  inline void
  FinishSlowJSInitIfMoreThanOneOwner(JSContext* aCx)
  {
    LifecycleFormDisabledCallback::FinishSlowJSInitIfMoreThanOneOwner(aCx);
  }
};
} // namespace binding_detail


class LifecycleFormResetCallback : public CallbackFunction
{
public:
  explicit inline LifecycleFormResetCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aCallbackGlobal, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aCallbackGlobal, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline LifecycleFormResetCallback(JSObject* aCallback, JSObject* aCallbackGlobal, const FastCallbackConstructor& )
    : CallbackFunction(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline LifecycleFormResetCallback(JSObject* aCallback, JSObject* aCallbackGlobal, JSObject* aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aCallbackGlobal, aAsyncStack, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline LifecycleFormResetCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  inline void
  Call(const T& thisVal, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "LifecycleFormResetCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetCallContext(), thisValJS, aRv);
  }

  inline void
  Call(ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "LifecycleFormResetCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    return Call(s.GetCallContext(), JS::UndefinedHandleValue, aRv);
  }

  template <typename T>
  inline void
  Call(const T& thisVal, const char* aExecutionReason = nullptr)
  {
    return Call(thisVal, IgnoreErrors(), aExecutionReason);
  }

  inline void
  Call(const char* aExecutionReason = nullptr)
  {
    return Call(IgnoreErrors(), aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const LifecycleFormResetCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  void Call(BindingCallContext& cx, JS::Handle<JS::Value> aThisVal, ErrorResult& aRv);
};


namespace binding_detail {
class FastLifecycleFormResetCallback : public LifecycleFormResetCallback
{
public:
  explicit inline FastLifecycleFormResetCallback(JSObject* aCallback, JSObject* aCallbackGlobal)
    : LifecycleFormResetCallback(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    LifecycleFormResetCallback::Trace(aTracer);
  }

  inline void
  FinishSlowJSInitIfMoreThanOneOwner(JSContext* aCx)
  {
    LifecycleFormResetCallback::FinishSlowJSInitIfMoreThanOneOwner(aCx);
  }
};
} // namespace binding_detail


class LifecycleFormStateRestoreCallback : public CallbackFunction
{
public:
  explicit inline LifecycleFormStateRestoreCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aCallbackGlobal, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aCallbackGlobal, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline LifecycleFormStateRestoreCallback(JSObject* aCallback, JSObject* aCallbackGlobal, const FastCallbackConstructor& )
    : CallbackFunction(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline LifecycleFormStateRestoreCallback(JSObject* aCallback, JSObject* aCallbackGlobal, JSObject* aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aCallbackGlobal, aAsyncStack, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline LifecycleFormStateRestoreCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  inline void
  Call(const T& thisVal, const Nullable<FileOrUSVStringOrFormData>& state, RestoreReason reason, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "LifecycleFormStateRestoreCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetCallContext(), thisValJS, state, reason, aRv);
  }

  inline void
  Call(const Nullable<FileOrUSVStringOrFormData>& state, RestoreReason reason, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "LifecycleFormStateRestoreCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    return Call(s.GetCallContext(), JS::UndefinedHandleValue, state, reason, aRv);
  }

  template <typename T>
  inline void
  Call(const T& thisVal, const Nullable<FileOrUSVStringOrFormData>& state, RestoreReason reason, const char* aExecutionReason = nullptr)
  {
    return Call(thisVal, state, reason, IgnoreErrors(), aExecutionReason);
  }

  inline void
  Call(const Nullable<FileOrUSVStringOrFormData>& state, RestoreReason reason, const char* aExecutionReason = nullptr)
  {
    return Call(state, reason, IgnoreErrors(), aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const LifecycleFormStateRestoreCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  void Call(BindingCallContext& cx, JS::Handle<JS::Value> aThisVal, const Nullable<FileOrUSVStringOrFormData>& state, RestoreReason reason, ErrorResult& aRv);
};


namespace binding_detail {
class FastLifecycleFormStateRestoreCallback : public LifecycleFormStateRestoreCallback
{
public:
  explicit inline FastLifecycleFormStateRestoreCallback(JSObject* aCallback, JSObject* aCallbackGlobal)
    : LifecycleFormStateRestoreCallback(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    LifecycleFormStateRestoreCallback::Trace(aTracer);
  }

  inline void
  FinishSlowJSInitIfMoreThanOneOwner(JSContext* aCx)
  {
    LifecycleFormStateRestoreCallback::FinishSlowJSInitIfMoreThanOneOwner(aCx);
  }
};
} // namespace binding_detail


class LifecycleGetCustomInterfaceCallback : public CallbackFunction
{
public:
  explicit inline LifecycleGetCustomInterfaceCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aCallbackGlobal, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aCallbackGlobal, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline LifecycleGetCustomInterfaceCallback(JSObject* aCallback, JSObject* aCallbackGlobal, const FastCallbackConstructor& )
    : CallbackFunction(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline LifecycleGetCustomInterfaceCallback(JSObject* aCallback, JSObject* aCallbackGlobal, JSObject* aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aCallbackGlobal, aAsyncStack, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline LifecycleGetCustomInterfaceCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  inline void
  Call(const T& thisVal, JS::Handle<JS::Value> iid, JS::MutableHandle<JSObject*> aRetVal, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "LifecycleGetCustomInterfaceCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetCallContext(), thisValJS, iid, aRetVal, aRv);
  }

  inline void
  Call(JS::Handle<JS::Value> iid, JS::MutableHandle<JSObject*> aRetVal, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "LifecycleGetCustomInterfaceCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    return Call(s.GetCallContext(), JS::UndefinedHandleValue, iid, aRetVal, aRv);
  }

  template <typename T>
  inline void
  Call(const T& thisVal, JS::Handle<JS::Value> iid, JS::MutableHandle<JSObject*> aRetVal, const char* aExecutionReason = nullptr)
  {
    return Call(thisVal, iid, aRetVal, IgnoreErrors(), aExecutionReason);
  }

  inline void
  Call(JS::Handle<JS::Value> iid, JS::MutableHandle<JSObject*> aRetVal, const char* aExecutionReason = nullptr)
  {
    return Call(iid, aRetVal, IgnoreErrors(), aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const LifecycleGetCustomInterfaceCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  void Call(BindingCallContext& cx, JS::Handle<JS::Value> aThisVal, JS::Handle<JS::Value> iid, JS::MutableHandle<JSObject*> aRetVal, ErrorResult& aRv);
};


namespace binding_detail {
class FastLifecycleGetCustomInterfaceCallback : public LifecycleGetCustomInterfaceCallback
{
public:
  explicit inline FastLifecycleGetCustomInterfaceCallback(JSObject* aCallback, JSObject* aCallbackGlobal)
    : LifecycleGetCustomInterfaceCallback(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    LifecycleGetCustomInterfaceCallback::Trace(aTracer);
  }

  inline void
  FinishSlowJSInitIfMoreThanOneOwner(JSContext* aCx)
  {
    LifecycleGetCustomInterfaceCallback::FinishSlowJSInitIfMoreThanOneOwner(aCx);
  }
};
} // namespace binding_detail


namespace CustomElementRegistry_Binding {

  typedef mozilla::dom::CustomElementRegistry NativeType;

  bool
  Wrap(JSContext* aCx, mozilla::dom::CustomElementRegistry* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::CustomElementRegistry,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace CustomElementRegistry_Binding



} // namespace dom


template <>
struct MaxContiguousEnumValue<dom::RestoreReason>
{
  static constexpr dom::RestoreReason value = dom::RestoreReason::Autocomplete;

  static_assert(static_cast<uint8_t>(dom::RestoreReason::Restore) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::RestoreReason>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};


} // namespace mozilla

#endif // DOM_CUSTOMELEMENTREGISTRYBINDING_H_
