#ifndef DOM_BINDINGNAMES_H_
#define DOM_BINDINGNAMES_H_

#include <stddef.h>
#include <stdint.h>
#include "mozilla/Attributes.h"

namespace mozilla::dom {

enum class BindingNamesOffset : uint16_t {
  ANGLE_instanced_arrays = 0,
  APZHitResultFlags = 23,
  AbortController = 41,
  AbortSignal = 57,
  AbstractRange = 69,
  AccessibleNode = 83,
  Addon = 98,
  AddonEvent = 104,
  AddonInstall = 115,
  AddonManager = 128,
  AddonManagerPermissions = 141,
  AnalyserNode = 165,
  Animation = 178,
  AnimationEffect = 188,
  AnimationEvent = 204,
  AnimationPlaybackEvent = 219,
  AnimationTimeline = 242,
  AnonymousContent = 260,
  Attr = 277,
  Audio = 282,
  AudioBuffer = 288,
  AudioBufferSourceNode = 300,
  AudioContext = 322,
  AudioData = 335,
  AudioDecoder = 345,
  AudioDestinationNode = 358,
  AudioEncoder = 379,
  AudioListener = 392,
  AudioNode = 406,
  AudioParam = 416,
  AudioParamMap = 427,
  AudioProcessingEvent = 441,
  AudioScheduledSourceNode = 462,
  AudioTrack = 487,
  AudioTrackList = 498,
  AudioWorklet = 513,
  AudioWorkletGlobalScope = 526,
  AudioWorkletNode = 550,
  AudioWorkletProcessor = 567,
  AuthenticatorAssertionResponse = 589,
  AuthenticatorAttestationResponse = 620,
  AuthenticatorResponse = 653,
  BarProp = 675,
  BaseAudioContext = 683,
  BatteryManager = 700,
  BeforeUnloadEvent = 715,
  BiquadFilterNode = 733,
  Blob = 750,
  BlobEvent = 755,
  BroadcastChannel = 765,
  BrowsingContext = 782,
  BrowsingContextGroup = 798,
  ByteLengthQueuingStrategy = 819,
  CDATASection = 845,
  CSPViolationReportBody = 858,
  CSS = 881,
  CSSAnimation = 885,
  CSSColor = 898,
  CSSColorValue = 907,
  CSSConditionRule = 921,
  CSSContainerRule = 938,
  CSSCounterStyleRule = 955,
  CSSCustomMediaRule = 975,
  CSSCustomPropertyRegisteredEvent = 994,
  CSSFontFaceRule = 1027,
  CSSFontFeatureValuesRule = 1043,
  CSSFontPaletteValuesRule = 1068,
  CSSGroupingRule = 1093,
  CSSHSL = 1109,
  CSSHWB = 1116,
  CSSImageValue = 1123,
  CSSImportRule = 1137,
  CSSKeyframeRule = 1151,
  CSSKeyframesRule = 1167,
  CSSKeywordValue = 1184,
  CSSLCH = 1200,
  CSSLab = 1207,
  CSSLayerBlockRule = 1214,
  CSSLayerStatementRule = 1232,
  CSSMarginRule = 1254,
  CSSMathClamp = 1268,
  CSSMathInvert = 1281,
  CSSMathMax = 1295,
  CSSMathMin = 1306,
  CSSMathNegate = 1317,
  CSSMathProduct = 1331,
  CSSMathSum = 1346,
  CSSMathValue = 1357,
  CSSMatrixComponent = 1370,
  CSSMediaRule = 1389,
  CSSMozDocumentRule = 1402,
  CSSNamespaceRule = 1421,
  CSSNestedDeclarations = 1438,
  CSSNumericArray = 1460,
  CSSNumericValue = 1476,
  CSSOKLCH = 1492,
  CSSOKLab = 1501,
  CSSPageDescriptors = 1510,
  CSSPageRule = 1529,
  CSSPerspective = 1541,
  CSSPositionTryDescriptors = 1556,
  CSSPositionTryRule = 1582,
  CSSPropertyRule = 1601,
  CSSPseudoElement = 1617,
  CSSRGB = 1634,
  CSSRotate = 1641,
  CSSRule = 1651,
  CSSRuleList = 1659,
  CSSScale = 1671,
  CSSScopeRule = 1680,
  CSSSkew = 1693,
  CSSSkewX = 1701,
  CSSSkewY = 1710,
  CSSStartingStyleRule = 1719,
  CSSStyleDeclaration = 1740,
  CSSStyleProperties = 1760,
  CSSStyleRule = 1779,
  CSSStyleSheet = 1792,
  CSSStyleValue = 1806,
  CSSSupportsRule = 1820,
  CSSTransformComponent = 1836,
  CSSTransformValue = 1858,
  CSSTransition = 1876,
  CSSTranslate = 1890,
  CSSUnitValue = 1903,
  CSSUnparsedValue = 1916,
  CSSVariableReferenceValue = 1933,
  Cache = 1959,
  CacheStorage = 1965,
  CallbackDebuggerNotification = 1978,
  CanonicalBrowsingContext = 2007,
  CanvasCaptureMediaStream = 2032,
  CanvasGradient = 2057,
  CanvasPattern = 2072,
  CanvasRenderingContext2D = 2086,
  CaretPosition = 2111,
  CaretStateChangedEvent = 2125,
  ChannelMergerNode = 2148,
  ChannelSplitterNode = 2166,
  ChannelWrapper = 2186,
  CharacterData = 2201,
  CheckerboardReportService = 2215,
  ChildProcessMessageManager = 2241,
  ChildSHistory = 2268,
  ChromeMessageBroadcaster = 2282,
  ChromeMessageSender = 2307,
  ChromeNodeList = 2327,
  ChromeUtils = 2342,
  ChromeWorker = 2354,
  Client = 2367,
  Clients = 2374,
  Clipboard = 2382,
  ClipboardEvent = 2392,
  ClipboardItem = 2407,
  ClonedErrorHolder = 2421,
  CloseEvent = 2439,
  CloseWatcher = 2450,
  CommandEvent = 2463,
  Comment = 2476,
  CompositionEvent = 2484,
  CompressionStream = 2501,
  ConsoleInstance = 2519,
  ConstantSourceNode = 2535,
  ContentFrameMessageManager = 2554,
  ContentProcessMessageManager = 2581,
  ContentVisibilityAutoStateChangeEvent = 2610,
  ConvolverNode = 2648,
  CookieChangeEvent = 2662,
  CookieStore = 2680,
  CookieStoreManager = 2692,
  CountQueuingStrategy = 2711,
  CreateOfferRequest = 2732,
  Credential = 2751,
  CredentialsContainer = 2762,
  Crypto = 2783,
  CryptoKey = 2790,
  CustomElementRegistry = 2800,
  CustomEvent = 2822,
  CustomStateSet = 2834,
  DOMException = 2849,
  DOMImplementation = 2862,
  DOMLocalization = 2880,
  DOMMatrix = 2896,
  DOMMatrixReadOnly = 2906,
  DOMParser = 2924,
  DOMPoint = 2934,
  DOMPointReadOnly = 2943,
  DOMQuad = 2960,
  DOMRect = 2968,
  DOMRectList = 2976,
  DOMRectReadOnly = 2988,
  DOMStringList = 3004,
  DOMStringMap = 3018,
  DOMTokenList = 3031,
  DataTransfer = 3044,
  DataTransferItem = 3057,
  DataTransferItemList = 3074,
  DebuggerNotification = 3095,
  DebuggerNotificationObserver = 3116,
  DecompressionStream = 3145,
  DedicatedWorkerGlobalScope = 3165,
  DelayNode = 3192,
  DeprecationReportBody = 3202,
  DeviceAcceleration = 3224,
  DeviceLightEvent = 3243,
  DeviceMotionEvent = 3260,
  DeviceOrientationEvent = 3278,
  DeviceRotationRate = 3301,
  Directory = 3320,
  Document = 3330,
  DocumentFragment = 3339,
  DocumentL10n = 3356,
  DocumentTimeline = 3369,
  DocumentType = 3386,
  DominatorTree = 3399,
  DragEvent = 3413,
  DynamicsCompressorNode = 3423,
  EXT_blend_minmax = 3446,
  EXT_color_buffer_float = 3463,
  EXT_color_buffer_half_float = 3486,
  EXT_depth_clamp = 3514,
  EXT_disjoint_timer_query = 3530,
  EXT_float_blend = 3555,
  EXT_frag_depth = 3571,
  EXT_sRGB = 3586,
  EXT_shader_texture_lod = 3595,
  EXT_texture_compression_bptc = 3618,
  EXT_texture_compression_rgtc = 3647,
  EXT_texture_filter_anisotropic = 3676,
  EXT_texture_norm16 = 3707,
  Element = 3726,
  ElementInternals = 3734,
  EncodedAudioChunk = 3751,
  EncodedVideoChunk = 3769,
  ErrorEvent = 3787,
  Event = 3798,
  EventCallbackDebuggerNotification = 3804,
  EventCounts = 3838,
  EventSource = 3850,
  EventTarget = 3862,
  Exception = 3874,
  ExtendableCookieChangeEvent = 3884,
  ExtendableEvent = 3912,
  ExtendableMessageEvent = 3928,
  ExtensionAlarms = 3951,
  ExtensionBrowser = 3967,
  ExtensionBrowserSettings = 3984,
  ExtensionBrowserSettingsColorManagement = 4009,
  ExtensionDns = 4049,
  ExtensionEventManager = 4062,
  ExtensionMockAPI = 4084,
  ExtensionPort = 4101,
  ExtensionProxy = 4115,
  ExtensionRuntime = 4130,
  ExtensionScripting = 4147,
  ExtensionSetting = 4166,
  ExtensionTest = 4183,
  External = 4197,
  FeaturePolicy = 4206,
  FeaturePolicyViolationReportBody = 4220,
  FetchEvent = 4253,
  FetchObserver = 4264,
  File = 4278,
  FileList = 4283,
  FileReader = 4292,
  FileReaderSync = 4303,
  FileSystem = 4318,
  FileSystemDirectoryEntry = 4329,
  FileSystemDirectoryHandle = 4354,
  FileSystemDirectoryHandle_AsyncIterator = 4380,
  FileSystemDirectoryIterator = 4420,
  FileSystemDirectoryReader = 4448,
  FileSystemEntry = 4474,
  FileSystemFileEntry = 4490,
  FileSystemFileHandle = 4510,
  FileSystemHandle = 4531,
  FileSystemSyncAccessHandle = 4548,
  FileSystemWritableFileStream = 4575,
  Flex = 4604,
  FlexItemValues = 4609,
  FlexLineValues = 4624,
  FluentBundle = 4639,
  FluentBundleAsyncIterator = 4652,
  FluentBundleIterator = 4678,
  FluentPattern = 4699,
  FluentResource = 4713,
  FocusEvent = 4728,
  FontFace = 4739,
  FontFaceSet = 4748,
  FontFaceSetIterator = 4760,
  FontFaceSetLoadEvent = 4780,
  FormData = 4801,
  FormData_Iterator = 4810,
  FormDataEvent = 4828,
  FragmentDirective = 4842,
  FrameCrashedEvent = 4860,
  FrameLoader = 4878,
  GPU = 4890,
  GPUAdapter = 4894,
  GPUAdapterInfo = 4905,
  GPUBindGroup = 4920,
  GPUBindGroupLayout = 4933,
  GPUBuffer = 4952,
  GPUBufferUsage = 4962,
  GPUCanvasContext = 4977,
  GPUColorWrite = 4994,
  GPUCommandBuffer = 5008,
  GPUCommandEncoder = 5025,
  GPUCompilationInfo = 5043,
  GPUCompilationMessage = 5062,
  GPUComputePassEncoder = 5084,
  GPUComputePipeline = 5106,
  GPUDevice = 5125,
  GPUDeviceLostInfo = 5135,
  GPUError = 5153,
  GPUExternalTexture = 5162,
  GPUInternalError = 5181,
  GPUMapMode = 5198,
  GPUOutOfMemoryError = 5209,
  GPUPipelineError = 5229,
  GPUPipelineLayout = 5246,
  GPUQuerySet = 5264,
  GPUQueue = 5276,
  GPURenderBundle = 5285,
  GPURenderBundleEncoder = 5301,
  GPURenderPassEncoder = 5324,
  GPURenderPipeline = 5345,
  GPUSampler = 5363,
  GPUShaderModule = 5374,
  GPUShaderStage = 5390,
  GPUSupportedFeatures = 5405,
  GPUSupportedLimits = 5426,
  GPUTexture = 5445,
  GPUTextureUsage = 5456,
  GPUTextureView = 5472,
  GPUUncapturedErrorEvent = 5487,
  GPUValidationError = 5511,
  GainNode = 5530,
  Gamepad = 5539,
  GamepadAxisMoveEvent = 5547,
  GamepadButton = 5568,
  GamepadButtonEvent = 5582,
  GamepadEvent = 5601,
  GamepadHapticActuator = 5614,
  GamepadLightIndicator = 5636,
  GamepadPose = 5658,
  GamepadServiceTest = 5670,
  GamepadTouch = 5689,
  Geolocation = 5702,
  GeolocationCoordinates = 5714,
  GeolocationPosition = 5737,
  GeolocationPositionError = 5757,
  GetUserMediaRequest = 5782,
  GleanBoolean = 5802,
  GleanCategory = 5815,
  GleanCounter = 5829,
  GleanCustomDistribution = 5842,
  GleanDatetime = 5866,
  GleanDenominator = 5880,
  GleanDualLabeledCounter = 5897,
  GleanEvent = 5921,
  GleanImpl = 5932,
  GleanLabeled = 5942,
  GleanMemoryDistribution = 5955,
  GleanMetric = 5979,
  GleanNumerator = 5991,
  GleanObject = 6006,
  GleanPingsImpl = 6018,
  GleanQuantity = 6033,
  GleanRate = 6047,
  GleanString = 6057,
  GleanStringList = 6069,
  GleanText = 6085,
  GleanTimespan = 6095,
  GleanTimingDistribution = 6109,
  GleanUrl = 6133,
  GleanUuid = 6142,
  Grid = 6152,
  GridArea = 6157,
  GridDimension = 6166,
  GridLine = 6180,
  GridLines = 6189,
  GridTrack = 6199,
  GridTracks = 6209,
  HTMLAllCollection = 6220,
  HTMLAnchorElement = 6238,
  HTMLAreaElement = 6256,
  HTMLAudioElement = 6272,
  HTMLBRElement = 6289,
  HTMLBaseElement = 6303,
  HTMLBodyElement = 6319,
  HTMLButtonElement = 6335,
  HTMLCanvasElement = 6353,
  HTMLCollection = 6371,
  HTMLDListElement = 6386,
  HTMLDataElement = 6403,
  HTMLDataListElement = 6419,
  HTMLDetailsElement = 6439,
  HTMLDialogElement = 6458,
  HTMLDirectoryElement = 6476,
  HTMLDivElement = 6497,
  HTMLDocument = 6512,
  HTMLElement = 6525,
  HTMLEmbedElement = 6537,
  HTMLFieldSetElement = 6554,
  HTMLFontElement = 6574,
  HTMLFormControlsCollection = 6590,
  HTMLFormElement = 6617,
  HTMLFrameElement = 6633,
  HTMLFrameSetElement = 6650,
  HTMLHRElement = 6670,
  HTMLHeadElement = 6684,
  HTMLHeadingElement = 6700,
  HTMLHtmlElement = 6719,
  HTMLIFrameElement = 6735,
  HTMLImageElement = 6753,
  HTMLInputElement = 6770,
  HTMLLIElement = 6787,
  HTMLLabelElement = 6801,
  HTMLLegendElement = 6818,
  HTMLLinkElement = 6836,
  HTMLMapElement = 6852,
  HTMLMarqueeElement = 6867,
  HTMLMediaElement = 6886,
  HTMLMenuElement = 6903,
  HTMLMetaElement = 6919,
  HTMLMeterElement = 6935,
  HTMLModElement = 6952,
  HTMLOListElement = 6967,
  HTMLObjectElement = 6984,
  HTMLOptGroupElement = 7002,
  HTMLOptionElement = 7022,
  HTMLOptionsCollection = 7040,
  HTMLOutputElement = 7062,
  HTMLParagraphElement = 7080,
  HTMLParamElement = 7101,
  HTMLPictureElement = 7118,
  HTMLPreElement = 7137,
  HTMLProgressElement = 7152,
  HTMLQuoteElement = 7172,
  HTMLScriptElement = 7189,
  HTMLSelectElement = 7207,
  HTMLSlotElement = 7225,
  HTMLSourceElement = 7241,
  HTMLSpanElement = 7259,
  HTMLStyleElement = 7275,
  HTMLTableCaptionElement = 7292,
  HTMLTableCellElement = 7316,
  HTMLTableColElement = 7337,
  HTMLTableElement = 7357,
  HTMLTableRowElement = 7374,
  HTMLTableSectionElement = 7394,
  HTMLTemplateElement = 7418,
  HTMLTextAreaElement = 7438,
  HTMLTimeElement = 7458,
  HTMLTitleElement = 7474,
  HTMLTrackElement = 7491,
  HTMLUListElement = 7508,
  HTMLUnknownElement = 7525,
  HTMLVideoElement = 7544,
  HashChangeEvent = 7561,
  Headers = 7577,
  Headers_Iterator = 7585,
  HeapSnapshot = 7602,
  Highlight = 7615,
  HighlightRegistry = 7625,
  History = 7643,
  IDBCursor = 7651,
  IDBCursorWithValue = 7661,
  IDBDatabase = 7680,
  IDBFactory = 7692,
  IDBIndex = 7703,
  IDBKeyRange = 7712,
  IDBObjectStore = 7724,
  IDBOpenDBRequest = 7739,
  IDBRequest = 7756,
  IDBTransaction = 7767,
  IDBVersionChangeEvent = 7782,
  IIRFilterNode = 7804,
  IOUtils = 7818,
  IdentityCredential = 7826,
  IdentityProvider = 7845,
  IdleDeadline = 7862,
  Image = 7875,
  ImageBitmap = 7881,
  ImageBitmapRenderingContext = 7893,
  ImageCapture = 7921,
  ImageCaptureError = 7934,
  ImageCaptureErrorEvent = 7952,
  ImageData = 7975,
  ImageDecoder = 7985,
  ImageDocument = 7998,
  ImageTrack = 8012,
  ImageTrackList = 8023,
  InferenceSession = 8038,
  InputEvent = 8055,
  InspectorCSSParser = 8066,
  InspectorFontFace = 8085,
  InspectorUtils = 8103,
  IntersectionObserver = 8118,
  IntersectionObserverEntry = 8139,
  IntlUtils = 8165,
  JSProcessActorChild = 8175,
  JSProcessActorParent = 8195,
  JSWindowActorChild = 8216,
  JSWindowActorParent = 8235,
  KeyEvent = 8255,
  KeyboardEvent = 8264,
  KeyframeEffect = 8278,
  L10nFileSource = 8293,
  L10nOverlays = 8308,
  L10nRegistry = 8321,
  LargestContentfulPaint = 8334,
  LegacyMozTCPSocket = 8357,
  Localization = 8376,
  Location = 8389,
  Lock = 8398,
  LockManager = 8403,
  MIDIAccess = 8415,
  MIDIConnectionEvent = 8426,
  MIDIInput = 8446,
  MIDIInputMap = 8456,
  MIDIMessageEvent = 8469,
  MIDIOutput = 8486,
  MIDIOutputMap = 8497,
  MIDIPort = 8511,
  MLS = 8520,
  MLSGroupView = 8524,
  MOZ_debug = 8537,
  MatchGlob = 8547,
  MatchPattern = 8557,
  MatchPatternSet = 8570,
  MathMLElement = 8586,
  MediaCapabilities = 8600,
  MediaControlService = 8618,
  MediaController = 8638,
  MediaDeviceInfo = 8654,
  MediaDevices = 8670,
  MediaElementAudioSourceNode = 8683,
  MediaEncryptedEvent = 8711,
  MediaError = 8731,
  MediaKeyError = 8742,
  MediaKeyMessageEvent = 8756,
  MediaKeySession = 8777,
  MediaKeyStatusMap = 8793,
  MediaKeyStatusMap_Iterator = 8811,
  MediaKeySystemAccess = 8838,
  MediaKeys = 8859,
  MediaList = 8869,
  MediaMetadata = 8879,
  MediaQueryList = 8893,
  MediaQueryListEvent = 8908,
  MediaRecorder = 8928,
  MediaRecorderErrorEvent = 8942,
  MediaSession = 8966,
  MediaSource = 8979,
  MediaStream = 8991,
  MediaStreamAudioDestinationNode = 9003,
  MediaStreamAudioSourceNode = 9035,
  MediaStreamError = 9062,
  MediaStreamEvent = 9079,
  MediaStreamTrack = 9096,
  MediaStreamTrackAudioSourceNode = 9113,
  MediaStreamTrackEvent = 9145,
  MerchantValidationEvent = 9167,
  MessageBroadcaster = 9191,
  MessageChannel = 9210,
  MessageEvent = 9225,
  MessageListenerManager = 9238,
  MessagePort = 9261,
  MessageSender = 9273,
  MimeType = 9287,
  MimeTypeArray = 9296,
  MouseEvent = 9310,
  MouseScrollEvent = 9321,
  MozCanvasPrintState = 9338,
  MozDocumentMatcher = 9358,
  MozDocumentObserver = 9377,
  MozQueryInterface = 9397,
  MozSharedMap = 9415,
  MozSharedMap_Iterator = 9428,
  MozSharedMapChangeEvent = 9450,
  MozStorageAsyncStatementParams = 9474,
  MozStorageStatementParams = 9505,
  MozStorageStatementRow = 9531,
  MozWritableSharedMap = 9554,
  MutationObserver = 9575,
  MutationRecord = 9592,
  NamedNodeMap = 9607,
  NavigateEvent = 9620,
  Navigation = 9634,
  NavigationActivation = 9645,
  NavigationCurrentEntryChangeEvent = 9666,
  NavigationDestination = 9700,
  NavigationHistoryEntry = 9722,
  NavigationPrecommitController = 9745,
  NavigationPreloadManager = 9775,
  NavigationTransition = 9800,
  Navigator = 9821,
  NavigatorLogin = 9831,
  NetworkInformation = 9846,
  Node = 9865,
  NodeFilter = 9870,
  NodeIterator = 9881,
  NodeList = 9894,
  Notification = 9903,
  NotificationEvent = 9916,
  NotifyPaintEvent = 9934,
  OES_draw_buffers_indexed = 9951,
  OES_element_index_uint = 9976,
  OES_fbo_render_mipmap = 9999,
  OES_standard_derivatives = 10021,
  OES_texture_float = 10046,
  OES_texture_float_linear = 10064,
  OES_texture_half_float = 10089,
  OES_texture_half_float_linear = 10112,
  OES_vertex_array_object = 10142,
  OVR_multiview2 = 10166,
  OfflineAudioCompletionEvent = 10181,
  OfflineAudioContext = 10209,
  OffscreenCanvas = 10229,
  OffscreenCanvasRenderingContext2D = 10245,
  Option = 10279,
  OscillatorNode = 10286,
  PageTransitionEvent = 10301,
  PaintRequest = 10321,
  PaintRequestList = 10334,
  PaintWorkletGlobalScope = 10351,
  PannerNode = 10375,
  ParentProcessMessageManager = 10386,
  Path2D = 10414,
  PathUtils = 10421,
  PaymentAddress = 10431,
  PaymentMethodChangeEvent = 10446,
  PaymentRequest = 10471,
  PaymentRequestUpdateEvent = 10486,
  PaymentResponse = 10512,
  Performance = 10528,
  PerformanceEntry = 10540,
  PerformanceEntryEvent = 10557,
  PerformanceEventTiming = 10579,
  PerformanceMark = 10602,
  PerformanceMeasure = 10618,
  PerformanceNavigation = 10637,
  PerformanceNavigationTiming = 10659,
  PerformanceObserver = 10687,
  PerformanceObserverEntryList = 10707,
  PerformancePaintTiming = 10736,
  PerformanceResourceTiming = 10759,
  PerformanceServerTiming = 10785,
  PerformanceTiming = 10809,
  PeriodicWave = 10827,
  PermissionStatus = 10840,
  Permissions = 10857,
  PlacesBookmark = 10869,
  PlacesBookmarkAddition = 10884,
  PlacesBookmarkChanged = 10907,
  PlacesBookmarkGuid = 10929,
  PlacesBookmarkKeyword = 10948,
  PlacesBookmarkMoved = 10970,
  PlacesBookmarkRemoved = 10990,
  PlacesBookmarkTags = 11012,
  PlacesBookmarkTime = 11031,
  PlacesBookmarkTitle = 11050,
  PlacesBookmarkUrl = 11070,
  PlacesEvent = 11088,
  PlacesEventCounts = 11100,
  PlacesFavicon = 11118,
  PlacesHistoryCleared = 11132,
  PlacesObservers = 11153,
  PlacesPurgeCaches = 11169,
  PlacesRanking = 11187,
  PlacesVisit = 11201,
  PlacesVisitRemoved = 11213,
  PlacesVisitTitle = 11232,
  PlacesWeakCallbackWrapper = 11249,
  Plugin = 11275,
  PluginArray = 11282,
  PluginCrashedEvent = 11294,
  PointerEvent = 11313,
  PopStateEvent = 11326,
  PopupBlockedEvent = 11340,
  PopupPositionedEvent = 11358,
  PositionStateEvent = 11379,
  PrecompiledScript = 11398,
  PrivateAttribution = 11416,
  ProcessMessageManager = 11435,
  ProcessingInstruction = 11457,
  ProgressEvent = 11479,
  PromiseDebugging = 11493,
  PromiseNativeHandler = 11510,
  PromiseRejectionEvent = 11531,
  PublicKeyCredential = 11553,
  PushEvent = 11573,
  PushManager = 11583,
  PushManagerImpl = 11595,
  PushMessageData = 11611,
  PushSubscription = 11627,
  PushSubscriptionChangeEvent = 11644,
  PushSubscriptionOptions = 11672,
  RadioNodeList = 11696,
  Range = 11710,
  ReadableByteStreamController = 11716,
  ReadableStream = 11745,
  ReadableStream_AsyncIterator = 11760,
  ReadableStreamBYOBReader = 11789,
  ReadableStreamBYOBRequest = 11814,
  ReadableStreamDefaultController = 11840,
  ReadableStreamDefaultReader = 11872,
  RedirectBlockedEvent = 11900,
  Report = 11921,
  ReportBody = 11928,
  ReportingObserver = 11939,
  Request = 11957,
  ResizeObserver = 11965,
  ResizeObserverEntry = 11980,
  ResizeObserverSize = 12000,
  Response = 12019,
  SVGAElement = 12028,
  SVGAngle = 12040,
  SVGAnimateElement = 12049,
  SVGAnimateMotionElement = 12067,
  SVGAnimateTransformElement = 12091,
  SVGAnimatedAngle = 12118,
  SVGAnimatedBoolean = 12135,
  SVGAnimatedEnumeration = 12154,
  SVGAnimatedInteger = 12177,
  SVGAnimatedLength = 12196,
  SVGAnimatedLengthList = 12214,
  SVGAnimatedNumber = 12236,
  SVGAnimatedNumberList = 12254,
  SVGAnimatedPreserveAspectRatio = 12276,
  SVGAnimatedRect = 12307,
  SVGAnimatedString = 12323,
  SVGAnimatedTransformList = 12341,
  SVGAnimationElement = 12366,
  SVGCircleElement = 12386,
  SVGClipPathElement = 12403,
  SVGComponentTransferFunctionElement = 12422,
  SVGDefsElement = 12458,
  SVGDescElement = 12473,
  SVGElement = 12488,
  SVGEllipseElement = 12499,
  SVGFEBlendElement = 12517,
  SVGFEColorMatrixElement = 12535,
  SVGFEComponentTransferElement = 12559,
  SVGFECompositeElement = 12589,
  SVGFEConvolveMatrixElement = 12611,
  SVGFEDiffuseLightingElement = 12638,
  SVGFEDisplacementMapElement = 12666,
  SVGFEDistantLightElement = 12694,
  SVGFEDropShadowElement = 12719,
  SVGFEFloodElement = 12742,
  SVGFEFuncAElement = 12760,
  SVGFEFuncBElement = 12778,
  SVGFEFuncGElement = 12796,
  SVGFEFuncRElement = 12814,
  SVGFEGaussianBlurElement = 12832,
  SVGFEImageElement = 12857,
  SVGFEMergeElement = 12875,
  SVGFEMergeNodeElement = 12893,
  SVGFEMorphologyElement = 12915,
  SVGFEOffsetElement = 12938,
  SVGFEPointLightElement = 12957,
  SVGFESpecularLightingElement = 12980,
  SVGFESpotLightElement = 13009,
  SVGFETileElement = 13031,
  SVGFETurbulenceElement = 13048,
  SVGFilterElement = 13071,
  SVGForeignObjectElement = 13088,
  SVGGElement = 13112,
  SVGGeometryElement = 13124,
  SVGGradientElement = 13143,
  SVGGraphicsElement = 13162,
  SVGImageElement = 13181,
  SVGLength = 13197,
  SVGLengthList = 13207,
  SVGLineElement = 13221,
  SVGLinearGradientElement = 13236,
  SVGMPathElement = 13261,
  SVGMarkerElement = 13277,
  SVGMaskElement = 13294,
  SVGMatrix = 13309,
  SVGMetadataElement = 13319,
  SVGNumber = 13338,
  SVGNumberList = 13348,
  SVGPathElement = 13362,
  SVGPathSegment = 13377,
  SVGPatternElement = 13392,
  SVGPoint = 13410,
  SVGPointList = 13419,
  SVGPolygonElement = 13432,
  SVGPolylineElement = 13450,
  SVGPreserveAspectRatio = 13469,
  SVGRadialGradientElement = 13492,
  SVGRect = 13517,
  SVGRectElement = 13525,
  SVGSVGElement = 13540,
  SVGScriptElement = 13554,
  SVGSetElement = 13571,
  SVGStopElement = 13585,
  SVGStringList = 13600,
  SVGStyleElement = 13614,
  SVGSwitchElement = 13630,
  SVGSymbolElement = 13647,
  SVGTSpanElement = 13664,
  SVGTextContentElement = 13680,
  SVGTextElement = 13702,
  SVGTextPathElement = 13717,
  SVGTextPositioningElement = 13736,
  SVGTitleElement = 13762,
  SVGTransform = 13778,
  SVGTransformList = 13791,
  SVGUnitTypes = 13808,
  SVGUseElement = 13821,
  SVGViewElement = 13835,
  Sanitizer = 13850,
  Scheduler = 13860,
  Screen = 13870,
  ScreenLuminance = 13877,
  ScreenOrientation = 13893,
  ScriptProcessorNode = 13911,
  ScrollAreaEvent = 13931,
  SecurityPolicyViolationEvent = 13947,
  Selection = 13976,
  ServiceWorker = 13986,
  ServiceWorkerContainer = 14000,
  ServiceWorkerGlobalScope = 14023,
  ServiceWorkerRegistration = 14048,
  SessionStoreFormData = 14074,
  SessionStoreScrollData = 14095,
  SessionStoreUtils = 14118,
  ShadowRealmGlobalScope = 14136,
  ShadowRoot = 14159,
  SharedWorker = 14170,
  SharedWorkerGlobalScope = 14183,
  SimpleGestureEvent = 14207,
  SourceBuffer = 14226,
  SourceBufferList = 14239,
  SpeechGrammar = 14256,
  SpeechGrammarList = 14270,
  SpeechRecognition = 14288,
  SpeechRecognitionAlternative = 14306,
  SpeechRecognitionError = 14335,
  SpeechRecognitionEvent = 14358,
  SpeechRecognitionResult = 14381,
  SpeechRecognitionResultList = 14405,
  SpeechSynthesis = 14433,
  SpeechSynthesisErrorEvent = 14449,
  SpeechSynthesisEvent = 14475,
  SpeechSynthesisUtterance = 14496,
  SpeechSynthesisVoice = 14521,
  StaticRange = 14542,
  StereoPannerNode = 14554,
  Storage = 14571,
  StorageEvent = 14579,
  StorageManager = 14592,
  StreamFilter = 14607,
  StreamFilterDataEvent = 14620,
  StructuredCloneHolder = 14642,
  StructuredCloneTester = 14664,
  StylePropertyMap = 14686,
  StylePropertyMapReadOnly = 14703,
  StylePropertyMapReadOnly_Iterator = 14728,
  StyleSheet = 14762,
  StyleSheetApplicableStateChangeEvent = 14773,
  StyleSheetList = 14810,
  StyleSheetRemovedEvent = 14825,
  SubmitEvent = 14848,
  SubtleCrypto = 14860,
  SyncMessageSender = 14873,
  SyncReadFile = 14891,
  TCPServerSocket = 14904,
  TCPServerSocketEvent = 14920,
  TCPSocket = 14941,
  TCPSocketErrorEvent = 14951,
  TCPSocketEvent = 14971,
  TaskController = 14986,
  TaskPriorityChangeEvent = 15001,
  TaskSignal = 15025,
  Tensor = 15036,
  TestUtils = 15043,
  TestingDeprecatedInterface = 15053,
  Text = 15080,
  TextClause = 15085,
  TextDecoder = 15096,
  TextDecoderStream = 15108,
  TextEncoder = 15126,
  TextEncoderStream = 15138,
  TextEvent = 15156,
  TextMetrics = 15166,
  TextTrack = 15178,
  TextTrackCue = 15188,
  TextTrackCueList = 15201,
  TextTrackList = 15218,
  TimeEvent = 15232,
  TimeRanges = 15242,
  ToggleEvent = 15253,
  Touch = 15265,
  TouchEvent = 15271,
  TouchList = 15282,
  TrackEvent = 15292,
  TransformStream = 15303,
  TransformStreamDefaultController = 15319,
  TransitionEvent = 15352,
  TreeColumn = 15368,
  TreeColumns = 15379,
  TreeContentView = 15391,
  TreeWalker = 15407,
  TrustedHTML = 15418,
  TrustedScript = 15430,
  TrustedScriptURL = 15444,
  TrustedTypePolicy = 15461,
  TrustedTypePolicyFactory = 15479,
  UDPMessageEvent = 15504,
  UDPSocket = 15520,
  UIEvent = 15530,
  URL = 15538,
  URLPattern = 15542,
  URLSearchParams = 15553,
  URLSearchParams_Iterator = 15569,
  UniFFIPointer = 15594,
  UniFFIScaffolding = 15608,
  UserActivation = 15626,
  UserInteraction = 15641,
  UserProximityEvent = 15657,
  VRDisplay = 15676,
  VRDisplayCapabilities = 15686,
  VRDisplayEvent = 15708,
  VREyeParameters = 15723,
  VRFieldOfView = 15739,
  VRFrameData = 15753,
  VRMockController = 15765,
  VRMockDisplay = 15782,
  VRPose = 15796,
  VRServiceTest = 15803,
  VRStageParameters = 15817,
  VTTCue = 15835,
  VTTRegion = 15842,
  ValidityState = 15852,
  VideoColorSpace = 15866,
  VideoDecoder = 15882,
  VideoEncoder = 15895,
  VideoFrame = 15908,
  VideoPlaybackQuality = 15919,
  VideoTrack = 15940,
  VideoTrackList = 15951,
  ViewTransition = 15966,
  VisualViewport = 15981,
  WEBGL_color_buffer_float = 15996,
  WEBGL_compressed_texture_astc = 16021,
  WEBGL_compressed_texture_etc = 16051,
  WEBGL_compressed_texture_etc1 = 16080,
  WEBGL_compressed_texture_pvrtc = 16110,
  WEBGL_compressed_texture_s3tc = 16141,
  WEBGL_compressed_texture_s3tc_srgb = 16171,
  WEBGL_debug_renderer_info = 16206,
  WEBGL_debug_shaders = 16232,
  WEBGL_depth_texture = 16252,
  WEBGL_draw_buffers = 16272,
  WEBGL_explicit_present = 16291,
  WEBGL_lose_context = 16314,
  WEBGL_provoking_vertex = 16333,
  WGSLLanguageFeatures = 16356,
  WakeLock = 16377,
  WakeLockSentinel = 16386,
  WaveShaperNode = 16403,
  WebExtensionContentScript = 16418,
  WebExtensionPolicy = 16444,
  WebGL2RenderingContext = 16463,
  WebGLActiveInfo = 16486,
  WebGLBuffer = 16502,
  WebGLContextEvent = 16514,
  WebGLFramebuffer = 16532,
  WebGLProgram = 16549,
  WebGLQuery = 16562,
  WebGLRenderbuffer = 16573,
  WebGLRenderingContext = 16591,
  WebGLSampler = 16613,
  WebGLShader = 16626,
  WebGLShaderPrecisionFormat = 16638,
  WebGLSync = 16665,
  WebGLTexture = 16675,
  WebGLTransformFeedback = 16688,
  WebGLUniformLocation = 16711,
  WebGLVertexArrayObject = 16732,
  WebKitCSSMatrix = 16755,
  WebSocket = 16771,
  WebTransport = 16781,
  WebTransportBidirectionalStream = 16794,
  WebTransportDatagramDuplexStream = 16826,
  WebTransportError = 16859,
  WebTransportReceiveStream = 16877,
  WebTransportSendStream = 16903,
  WheelEvent = 16926,
  Window = 16937,
  WindowClient = 16944,
  WindowContext = 16957,
  WindowGlobalChild = 16971,
  WindowGlobalParent = 16989,
  WindowRoot = 17008,
  Worker = 17019,
  WorkerDebuggerGlobalScope = 17026,
  WorkerGlobalScope = 17052,
  WorkerLocation = 17070,
  WorkerNavigator = 17085,
  WorkerTestUtils = 17101,
  Worklet = 17117,
  WorkletGlobalScope = 17125,
  WritableStream = 17144,
  WritableStreamDefaultController = 17159,
  WritableStreamDefaultWriter = 17191,
  XMLDocument = 17219,
  XMLHttpRequest = 17231,
  XMLHttpRequestEventTarget = 17246,
  XMLHttpRequestUpload = 17272,
  XMLSerializer = 17293,
  XPathEvaluator = 17307,
  XPathExpression = 17322,
  XPathResult = 17338,
  XRBoundedReferenceSpace = 17350,
  XRFrame = 17374,
  XRInputSource = 17382,
  XRInputSourceArray = 17396,
  XRInputSourceEvent = 17415,
  XRInputSourcesChangeEvent = 17434,
  XRPose = 17460,
  XRReferenceSpace = 17467,
  XRReferenceSpaceEvent = 17484,
  XRRenderState = 17506,
  XRRigidTransform = 17520,
  XRSession = 17537,
  XRSessionEvent = 17547,
  XRSpace = 17562,
  XRSystem = 17570,
  XRView = 17579,
  XRViewerPose = 17586,
  XRViewport = 17599,
  XRWebGLLayer = 17610,
  XSLTProcessor = 17623,
  XULCommandEvent = 17637,
  XULElement = 17653,
  XULFrameElement = 17664,
  XULMenuElement = 17680,
  XULPopupElement = 17695,
  XULResizerElement = 17711,
  XULTextElement = 17729,
  XULTreeElement = 17744,
  console = 17759,
  webkitSpeechGrammar = 17767,
  webkitSpeechGrammarList = 17787,
  webkitSpeechRecognition = 17811,
  webkitURL = 17835,
};

namespace binding_detail {
extern const char sBindingNames[];
}  // namespace binding_detail

MOZ_ALWAYS_INLINE const char* BindingName(BindingNamesOffset aOffset) {
  return binding_detail::sBindingNames + static_cast<size_t>(aOffset);
}

} // namespace mozilla::dom


#endif // DOM_BINDINGNAMES_H_
