// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanBrowserContentMetrics_h
#define mozilla_GleanBrowserContentMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace browser_engagement {
  /**
   * generated from browser.engagement.bookmarks_toolbar_bookmark_added
   * The count of bookmarks added to the bookmarks toolbar. This counts bookmarks created on the bookmarks toolbar and bookmarks moved to the bookmarks toolbar. This metric was generated to correspond to the Legacy Telemetry scalar browser.engagement.bookmarks_toolbar_bookmark_added.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> bookmarks_toolbar_bookmark_added(12);

  /**
   * generated from browser.engagement.bookmarks_toolbar_bookmark_opened
   * The count of bookmarks opened from the Bookmarks Toolbar. This counts bookmarks opened on the toolbar and bookmarks opened from the 'symlinked' Other Bookmarks folder on the Bookmarks Toolbar. It does not count Bookmarks Toolbar bookmarks opened via the Library, Bookmarks Menu, or other UI since the goal is to measure interactions that pass through the toolbar. This metric was generated to correspond to the Legacy Telemetry scalar browser.engagement.bookmarks_toolbar_bookmark_opened.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> bookmarks_toolbar_bookmark_opened(13);

  /**
   * generated from browser.engagement.total_top_visits
   */
  enum class TotalTopVisitsLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Count the number of times a new top page was starting to load
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram FX_TOTAL_TOP_VISITS.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, TotalTopVisitsLabel> total_top_visits(14);
}

namespace browser_timings {
  /**
   * generated from browser.timings.new_window
   * Firefox: Time taken to open a new browser window (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_NEW_WINDOW_MS.
   */
  constexpr impl::TimingDistributionMetric new_window(40);

  /**
   * generated from browser.timings.page_load
   * Firefox: Time taken to load a page (ms). This includes all static contents, no dynamic content. Page reloads and loading of about: pages are not included.
   * This metric was generated to correspond to the Legacy Telemetry linear histogram FX_PAGE_LOAD_MS_2.
   */
  constexpr impl::TimingDistributionMetric page_load(41);

  /**
   * generated from browser.timings.page_reload_normal
   * Firefox: Time taken to reload a page (ms) when using the LOAD_RELOAD_NORMAL flag
   * This metric was generated to correspond to the Legacy Telemetry linear histogram FX_PAGE_RELOAD_NORMAL_MS.
   */
  constexpr impl::TimingDistributionMetric page_reload_normal(42);

  /**
   * generated from browser.timings.page_reload_skip_cache
   * Firefox: Time taken to reload a page (ms) when caches are skipped
   * This metric was generated to correspond to the Legacy Telemetry linear histogram FX_PAGE_RELOAD_SKIP_CACHE_MS.
   */
  constexpr impl::TimingDistributionMetric page_reload_skip_cache(43);

  /**
   * generated from browser.timings.startup_timeline
   */
  enum class StartupTimelineLabel: uint16_t {
    eDelayedstartupstarted = 0,
    eDelayedstartupfinished = 1,
    eBlankwindowshown = 2,
    e__Other__,
  };
  /**
   * Events on the startup timeline, in millis since process creation.
   * Previously carried in the Legacy "main" ping `simpleMeasurements`.
   */
  constexpr impl::Labeled<impl::QuantityMetric, StartupTimelineLabel> startup_timeline(44);

  /**
   * generated from browser.timings.tab_click
   * Firefox: Time in ms spent on switching tabs in response to a tab click
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_TAB_CLICK_MS.
   */
  constexpr impl::TimingDistributionMetric tab_click(45);
}

namespace networking {
  /**
   * generated from networking.captive_portal_banner_display_time
   */
  enum class CaptivePortalBannerDisplayTimeLabel: uint16_t {
    eSuccess = 0,
    eAbort = 1,
    eDismiss = 2,
    e__Other__,
  };
  /**
   * Number of seconds the captive portal banner was displayed for, keyed by close reason:
   *   "success" - the portal login was completed
   *   "abort"   - the portal login was aborted (e.g. loss of network)
   *   "dismiss" - the user dismissed the banner
   * This metric was generated to correspond to the Legacy Telemetry scalar networking.captive_portal_banner_display_time.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, CaptivePortalBannerDisplayTimeLabel> captive_portal_banner_display_time(47);

  /**
   * generated from networking.captive_portal_banner_displayed
   * Number of times the captive portal banner was displayed in this session. This metric was generated to correspond to the Legacy Telemetry scalar networking.captive_portal_banner_displayed.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> captive_portal_banner_displayed(48);
}

namespace security_ui_protectionspopup {
  /**
   * generated from security.ui.protectionspopup.click_cookieb_toggle_off
   */
  /**
   * User interaction by click events in the protections panel. This event was generated to correspond to the Legacy Telemetry event security.ui.protectionspopup.click#cookieb_toggle_off.
   */
  constexpr impl::EventMetric<NoExtraKeys> click_cookieb_toggle_off(192);

  /**
   * generated from security.ui.protectionspopup.click_cookieb_toggle_on
   */
  /**
   * User interaction by click events in the protections panel. This event was generated to correspond to the Legacy Telemetry event security.ui.protectionspopup.click#cookieb_toggle_on.
   */
  constexpr impl::EventMetric<NoExtraKeys> click_cookieb_toggle_on(193);

  /**
   * generated from security.ui.protectionspopup.click_cookies
   */
  /**
   * User interaction by click events in the protections panel. This event was generated to correspond to the Legacy Telemetry event security.ui.protectionspopup.click#cookies.
   */
  constexpr impl::EventMetric<NoExtraKeys> click_cookies(194);

  /**
   * generated from security.ui.protectionspopup.click_cryptominers
   */
  /**
   * User interaction by click events in the protections panel. This event was generated to correspond to the Legacy Telemetry event security.ui.protectionspopup.click#cryptominers.
   */
  constexpr impl::EventMetric<NoExtraKeys> click_cryptominers(195);

  /**
   * generated from security.ui.protectionspopup.click_etp_toggle_off
   */
  /**
   * User interaction by click events in the protections panel. This event was generated to correspond to the Legacy Telemetry event security.ui.protectionspopup.click#etp_toggle_off.
   */
  constexpr impl::EventMetric<NoExtraKeys> click_etp_toggle_off(196);

  /**
   * generated from security.ui.protectionspopup.click_etp_toggle_on
   */
  /**
   * User interaction by click events in the protections panel. This event was generated to correspond to the Legacy Telemetry event security.ui.protectionspopup.click#etp_toggle_on.
   */
  constexpr impl::EventMetric<NoExtraKeys> click_etp_toggle_on(197);

  /**
   * generated from security.ui.protectionspopup.click_fingerprinters
   */
  /**
   * User interaction by click events in the protections panel. This event was generated to correspond to the Legacy Telemetry event security.ui.protectionspopup.click#fingerprinters.
   */
  constexpr impl::EventMetric<NoExtraKeys> click_fingerprinters(198);

  /**
   * generated from security.ui.protectionspopup.click_full_report
   */
  /**
   * User interaction by click events in the protections panel. This event was generated to correspond to the Legacy Telemetry event security.ui.protectionspopup.click#full_report.
   */
  constexpr impl::EventMetric<NoExtraKeys> click_full_report(199);

  /**
   * generated from security.ui.protectionspopup.click_milestone_message
   */
  /**
   * User interaction by click events in the protections panel. This event was generated to correspond to the Legacy Telemetry event security.ui.protectionspopup.click#milestone_message.
   */
  constexpr impl::EventMetric<NoExtraKeys> click_milestone_message(200);

  /**
   * generated from security.ui.protectionspopup.click_protectionspopup_cfr
   */
  struct ClickProtectionspopupCfrExtra {
    mozilla::Maybe<nsCString> message;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (message) {
        extraKeys.AppendElement()->AssignASCII("message");
        extraValues.EmplaceBack(message.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interaction by click events in the protections panel. This event was generated to correspond to the Legacy Telemetry event security.ui.protectionspopup.click#protectionspopup_cfr.
   */
  constexpr impl::EventMetric<ClickProtectionspopupCfrExtra> click_protectionspopup_cfr(201);

  /**
   * generated from security.ui.protectionspopup.click_settings
   */
  /**
   * User interaction by click events in the protections panel. This event was generated to correspond to the Legacy Telemetry event security.ui.protectionspopup.click#settings.
   */
  constexpr impl::EventMetric<NoExtraKeys> click_settings(202);

  /**
   * generated from security.ui.protectionspopup.click_smartblockembeds_toggle
   */
  struct ClickSmartblockembedsToggleExtra {
    mozilla::Maybe<bool> isblock;
    mozilla::Maybe<nsCString> openingreason;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (isblock) {
        extraKeys.AppendElement()->AssignASCII("isBlock");
        extraValues.AppendElement()->AssignASCII(isblock.value() ? "true" : "false");
      }
      if (openingreason) {
        extraKeys.AppendElement()->AssignASCII("openingReason");
        extraValues.EmplaceBack(openingreason.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Triggered when SmartBlock embed toggles are clicked by the user
   */
  constexpr impl::EventMetric<ClickSmartblockembedsToggleExtra> click_smartblockembeds_toggle(203);

  /**
   * generated from security.ui.protectionspopup.click_social
   */
  /**
   * User interaction by click events in the protections panel. This event was generated to correspond to the Legacy Telemetry event security.ui.protectionspopup.click#social.
   */
  constexpr impl::EventMetric<NoExtraKeys> click_social(204);

  /**
   * generated from security.ui.protectionspopup.click_subview_settings
   */
  struct ClickSubviewSettingsExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interaction by click events in the protections panel. This event was generated to correspond to the Legacy Telemetry event security.ui.protectionspopup.click#subview_settings.
   */
  constexpr impl::EventMetric<ClickSubviewSettingsExtra> click_subview_settings(205);

  /**
   * generated from security.ui.protectionspopup.click_trackers
   */
  /**
   * User interaction by click events in the protections panel. This event was generated to correspond to the Legacy Telemetry event security.ui.protectionspopup.click#trackers.
   */
  constexpr impl::EventMetric<NoExtraKeys> click_trackers(206);

  /**
   * generated from security.ui.protectionspopup.close_protections_popup
   */
  struct CloseProtectionsPopupExtra {
    mozilla::Maybe<nsCString> openingreason;
    mozilla::Maybe<bool> smartblocktoggleclicked;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (openingreason) {
        extraKeys.AppendElement()->AssignASCII("openingReason");
        extraValues.EmplaceBack(openingreason.value());
      }
      if (smartblocktoggleclicked) {
        extraKeys.AppendElement()->AssignASCII("smartblockToggleClicked");
        extraValues.AppendElement()->AssignASCII(smartblocktoggleclicked.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Triggered when the protections panel is closed. Records how the panel was opened and if the SmartBlock section had any interactions
   */
  constexpr impl::EventMetric<CloseProtectionsPopupExtra> close_protections_popup(207);

  /**
   * generated from security.ui.protectionspopup.open_protections_popup
   */
  struct OpenProtectionsPopupExtra {
    mozilla::Maybe<nsCString> openingreason;
    mozilla::Maybe<bool> smartblockembedtogglesshown;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (openingreason) {
        extraKeys.AppendElement()->AssignASCII("openingReason");
        extraValues.EmplaceBack(openingreason.value());
      }
      if (smartblockembedtogglesshown) {
        extraKeys.AppendElement()->AssignASCII("smartblockEmbedTogglesShown");
        extraValues.AppendElement()->AssignASCII(smartblockembedtogglesshown.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * How many times the protections panel was opened.
   */
  constexpr impl::EventMetric<OpenProtectionsPopupExtra> open_protections_popup(208);

  /**
   * generated from security.ui.protectionspopup.open_protectionspopup_cfr
   */
  struct OpenProtectionspopupCfrExtra {
    mozilla::Maybe<nsCString> message;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (message) {
        extraKeys.AppendElement()->AssignASCII("message");
        extraValues.EmplaceBack(message.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * How many times the protections panel was opened.
   */
  constexpr impl::EventMetric<OpenProtectionspopupCfrExtra> open_protectionspopup_cfr(209);

  /**
   * generated from security.ui.protectionspopup.smartblockembeds_shown
   * How many times the SmartBlock placeholders are shown on the page
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> smartblockembeds_shown(210);
}

} // namespace mozilla::glean

#endif // mozilla_GleanBrowserContentMetrics_h
